<?php
function start_secure_session(): void {
    if (session_status() === PHP_SESSION_NONE) {
        session_name('BTSESSID');
        session_start();
    }
}

function require_auth(): void {
    global $basePath;
    start_secure_session();
    if (empty($_SESSION['user'])) {
        header('Location: ' . $basePath . '/login');
        exit;
    }
}

function current_user(): ?array {
    start_secure_session();
    return $_SESSION['user'] ?? null;
}

function logout(): void {
    global $basePath;
    start_secure_session();
    $_SESSION = [];
    session_destroy();
    header('Location: ' . $basePath . '/login');
    exit;
}
