<?php
require_once __DIR__ . '/../../config/config.php';

function find_user_by_email(string $email): ?array {
    $pdo = getDbConnection();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
    $stmt->execute([':email' => $email]);
    return $stmt->fetch() ?: null;
}

function create_user(string $name, string $email, string $password): bool {
    $pdo = getDbConnection();
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (name, email, password) VALUES (:n, :e, :p)");
    return $stmt->execute([':n' => $name, ':e' => $email, ':p' => $hash]);
}

function verify_login(string $email, string $password): ?array {
    $user = find_user_by_email($email);
    if ($user && password_verify($password, $user['PASSWORD'])) {
        return $user;
    }
    return null;
}
