<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../src/lib/session.php';
require_once __DIR__ . '/../src/lib/auth.php';

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = strtolower(trim($_POST['email'] ?? ''));
    $pass = $_POST['password'] ?? '';
    $pass2 = $_POST['password_confirm'] ?? '';

    if ($name === '' || $email === '' || $pass === '') {
        $errors[] = "Tous les champs sont requis.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Email invalide.";
    } elseif ($pass !== $pass2) {
        $errors[] = "Les mots de passe ne correspondent pas.";
    } elseif (find_user_by_email($email)) {
        $errors[] = "Cet email est déjà utilisé.";
    }

    if (!$errors) {
        if (create_user($name, $email, $pass)) {
            header('Location: ' . $basePath . '/login');
            exit;
        } else {
            $errors[] = "Erreur lors de la création du compte.";
        }
    }
}

include __DIR__ . '/partials/header.php';
?>

<style>
    .form-container {
        max-width: 400px;
        margin: 40px auto;
        background: #1e293b;
        padding: 25px;
        border-radius: 10px;
        color: white;
        box-shadow: 0 4px 15px rgba(0,0,0,0.4);
    }
    .form-container h2 {
        color: #38bdf8;
        text-align: center;
        margin-bottom: 20px;
    }
    .form-container label {
        display: block;
        margin-top: 10px;
        font-weight: bold;
    }
    .form-container input {
        width: 95%;
        padding: 10px;
        margin-top: 5px;
        border-radius: 6px;
        border: 1px solid #334155;
        background-color: #0f172a;
        color: white;
        font-size: 14px;
        transition: border-color 0.3s, box-shadow 0.3s;
    }
    .form-container input:focus {
        border-color: #38bdf8;
        box-shadow: 0 0 5px #38bdf8;
        outline: none;
    }
    .form-container button {
        width: 100%;
        padding: 12px;
        background: #38bdf8;
        border: none;
        color: #0f172a;
        font-weight: bold;
        font-size: 16px;
        border-radius: 6px;
        margin-top: 15px;
        cursor: pointer;
        transition: background 0.3s, transform 0.2s;
    }
    .form-container button:hover {
        background: #0ea5e9;
        transform: scale(1.02);
    }
    .error-message {
        background: rgba(239, 68, 68, 0.15);
        border: 1px solid #ef4444;
        color: #f87171;
        padding: 8px;
        border-radius: 6px;
        margin-bottom: 10px;
        font-size: 14px;
    }
</style>

<div class="form-container">
    <h2>Inscription</h2>

    <?php foreach ($errors as $e): ?>
        <div class="error-message"><?= htmlspecialchars($e) ?></div>
    <?php endforeach; ?>

    <form method="post">
        <label>Nom complet</label>
        <input type="text" name="name" placeholder="Votre nom complet" required>

        <label>Email</label>
        <input type="email" name="email" placeholder="Votre email" required>

        <label>Mot de passe</label>
        <input type="password" name="password" placeholder="Votre mot de passe" required>

        <label>Confirmer mot de passe</label>
        <input type="password" name="password_confirm" placeholder="Confirmez votre mot de passe" required>

        <button type="submit">Créer le compte</button>
    </form>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>
