<?php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/lib/session.php';
$user = current_user();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Baltic Trader</title>
  <link rel="icon" type="image/svg+xml" 
          href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Ccircle cx='50' cy='50' r='45' fill='%231e40af'/%3E%3Cpath d='M30 45 L50 25 L70 45 L65 50 L50 35 L35 50 Z' fill='white'/%3E%3Crect x='25' y='50' width='50' height='25' rx='5' fill='white'/%3E%3Ctext x='50' y='68' text-anchor='middle' fill='%231e40af' font-size='14' font-family='Arial, sans-serif'%3ECG%3C/text%3E%3C/svg%3E">
    <style>
        body {
            background-color: #0f172a;
            color: white;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        a {
            color: #38bdf8;
            text-decoration: none;
        }
        .btn-circle {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            text-decoration: none;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        .btn-circle:hover {
            transform: scale(1.1);
        }
        .btn-red { background-color: #ef4444; }
        .btn-red:hover { background-color: #dc2626; }
        .btn-green { background-color: #22c55e; }
        .btn-green:hover { background-color: #16a34a; }
        .btn-blue { background-color: #3b82f6; }
        .btn-blue:hover { background-color: #2563eb; }
    </style>
</head>
<body>

<header style="background:#0f172a; color:white; padding:10px 20px; display:flex; justify-content:space-between; align-items:center;">
    <div style="font-weight:bold; font-size:2rem; color:#38bdf8;">
        ⚓ Baltic Trader
    </div>
    <nav style="display:flex; gap:10px; align-items:center;">
        <?php if ($user): ?>
            <!-- Bouton Déconnexion -->
            <a href="<?= $basePath; ?>/logout" class="btn-circle btn-red" title="Déconnexion">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
                    <polyline points="16 17 21 12 16 7"/>
                    <line x1="21" y1="12" x2="9" y2="12"/>
                </svg>
            </a>
        <?php else: ?>
            <!-- Bouton Connexion -->
            <a href="<?= $basePath; ?>/login" class="btn-circle btn-green" title="Connexion">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"/>
                    <polyline points="10 17 15 12 10 7"/>
                    <line x1="15" y1="12" x2="3" y2="12"/>
                </svg>
            </a>
            <!-- Bouton Inscription -->
            <a href="<?= $basePath; ?>/register" class="btn-circle btn-blue" title="Inscription">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                    <circle cx="8.5" cy="7" r="4"/>
                    <line x1="20" y1="8" x2="20" y2="14"/>
                    <line x1="23" y1="11" x2="17" y2="11"/>
                </svg>
            </a>
        <?php endif; ?>
    </nav>
</header>
