<?php
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

// Récupération des réglementations
$regulations = $pdo->query("
    SELECT id, description, STATUS
    FROM regulations
    ORDER BY id DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../partials/header.php';
?>

<div style="padding:20px; color:white; font-family:Arial, sans-serif;">
    <h2 style="color:#38bdf8; margin-bottom:15px;">📜 Gestion Réglementaire</h2>
    <?php if (!empty($_SESSION['success_message'])): ?>
        <div style="background:#16a34a; color:white; padding:10px; border-radius:4px; margin-bottom:15px;">
            <?= $_SESSION['success_message']; ?>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
<a href="<?= $basePath; ?>/../public/dashboard" 
    style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#38bdf8; color:#0f172a; font-weight:bold; border-radius:4px; text-decoration:none;">
        ⬅ Retour au Dashboard
    </a>
    <!-- Formulaire ajout réglementation -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter une réglementation</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_regulation.php" method="post" style="display:grid; gap:10px;">
            <textarea name="description" placeholder="Description de la réglementation" required style="padding:8px; border:none; border-radius:4px;"></textarea>
            <select name="STATUS" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Sélectionner un statut --</option>
                <option value="actif">Actif</option>
                <option value="expiré">Expiré</option>
                <option value="en attente">En attente</option>
            </select>
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer
            </button>
        </form>
    </div>

    <!-- Liste des réglementations -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📋 Liste des réglementations</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
            <thead>
                <tr style="background:#334155; color:white;">
                    <th style="padding:8px; text-align:left;">ID</th>
                    <th style="padding:8px; text-align:left;">Description</th>
                    <th style="padding:8px; text-align:left;">Statut</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($regulations) > 0): ?>
                    <?php foreach ($regulations as $r): ?>
                    <tr style="border-bottom:1px solid #1e293b;">
                        <td style="padding:8px;"><?= $r['id'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($r['description']) ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($r['STATUS']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" style="padding:8px; text-align:center; color:#94a3b8;">Aucune réglementation enregistrée</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
