<?php
$ROOT = dirname(__DIR__, 2); // modules/ → racine projet
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

// Liste des ports
$ports = $pdo->query("SELECT * FROM ports ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// Liste des coûts par port
$port_costs = $pdo->query("
    SELECT pc.id, p.name AS port_name, pc.cost_type, pc.amount, pc.unit
    FROM port_costs pc
    JOIN ports p ON p.id = pc.port_id
    ORDER BY pc.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../partials/header.php';
?>
<div style="padding:20px; color:white; font-family:Arial, sans-serif;">
    <h2 style="color:#38bdf8; margin-bottom:15px;">📍 Gestion des Ports</h2>

    <?php if (!empty($_SESSION['success_message'])): ?>
        <div style="background:#16a34a; color:white; padding:10px; border-radius:4px; margin-bottom:15px;">
            <?= $_SESSION['success_message']; ?>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>

    <a href="<?= $basePath; ?>/../public/dashboard" 
       style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#38bdf8; color:#0f172a; font-weight:bold; border-radius:4px; text-decoration:none;">
        ⬅ Retour au Dashboard
    </a>

    <!-- Formulaire ajout port -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un port</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_port.php" method="post" style="display:grid; gap:10px;">
            <input type="text" name="NAME" placeholder="Nom du port" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <input type="text" name="CODE" placeholder="Code" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <input type="text" name="location" placeholder="Localisation" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <input type="number" step="0.01" name="draft_limit" required placeholder="Tirant d’eau max (m)" style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <textarea name="notes" placeholder="Notes" style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;"></textarea>
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer
            </button>
        </form>
    </div>

    <!-- Formulaire ajout coût port -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un coût pour un port</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_port_cost.php" method="post" style="display:grid; gap:10px;">
            <select name="port_id" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
                <option value="">-- Sélectionner un port --</option>
                <?php foreach ($ports as $port): ?>
                    <option value="<?= $port['id'] ?>"><?= htmlspecialchars($port['NAME']) ?></option>
                <?php endforeach; ?>
            </select>
            <input type="text" name="cost_type" placeholder="Type de coût (ex: Pilotage)" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <input type="number" step="0.01" name="amount" placeholder="Montant" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <input type="text" name="unit" placeholder="Unité (ex: FCFA/t)" required style="padding:8px; border:1px solid white; border-radius:4px; background:#0f172a; color:white;">
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer le coût
            </button>
        </form>
    </div>

    <!-- Liste des ports -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📋 Liste des ports</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
            <thead>
                <tr style="background:#334155; color:white;">
                    <th style="padding:8px; text-align:left;">ID</th>
                    <th style="padding:8px; text-align:left;">Nom</th>
                    <th style="padding:8px; text-align:left;">Code</th>
                    <th style="padding:8px; text-align:left;">Localisation</th>
                    <th style="padding:8px; text-align:left;">Tirant d’eau max</th>
                    <th style="padding:8px; text-align:left;">Notes</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($ports) > 0): ?>
                    <?php foreach ($ports as $p): ?>
                    <tr style="border-bottom:1px solid #1e293b;">
                        <td style="padding:8px;"><?= $p['id'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($p['NAME']) ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($p['CODE']) ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($p['location']) ?></td>
                        <td style="padding:8px;"><?= $p['draft_limit'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($p['notes']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="padding:8px; text-align:center; color:#94a3b8;">Aucun port enregistré</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Liste des coûts -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">💰 Liste des coûts par port</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
            <thead>
                <tr style="background:#334155; color:white;">
                    <th style="padding:8px; text-align:left;">ID</th>
                    <th style="padding:8px; text-align:left;">Port</th>
                    <th style="padding:8px; text-align:left;">Type de coût</th>
                    <th style="padding:8px; text-align:left;">Montant</th>
                    <th style="padding:8px; text-align:left;">Unité</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($port_costs) > 0): ?>
                    <?php foreach ($port_costs as $c): ?>
                    <tr style="border-bottom:1px solid #1e293b;">
                        <td style="padding:8px;"><?= $c['id'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($c['port_name']) ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($c['cost_type']) ?></td>
                        <td style="padding:8px;"><?= number_format($c['amount'], 2, ',', ' ') ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($c['unit']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="padding:8px; text-align:center; color:#94a3b8;">Aucun coût enregistré</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
