<?php
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

// Récupération des OPEX navires
$opex_list = $pdo->query("
    SELECT id, vessel_name, weekly_cost, fuel_price_per_ton
    FROM vessel_opex
    ORDER BY id DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../partials/header.php';
?>

<div style="padding:20px; color:white; font-family:Arial, sans-serif;">
    <h2 style="color:#38bdf8; margin-bottom:15px;">⚙️ Gestion OPEX Navire</h2>
    <?php if (!empty($_SESSION['success_message'])): ?>
        <div style="background:#16a34a; color:white; padding:10px; border-radius:4px; margin-bottom:15px;">
            <?= $_SESSION['success_message']; ?>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
    <a href="<?= $basePath; ?>/../public/dashboard" 
        style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#38bdf8; color:#0f172a; font-weight:bold; border-radius:4px; text-decoration:none;">
            ⬅ Retour au Dashboard
    </a>
    <!-- Formulaire ajout OPEX -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un navire et ses coûts</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_opex.php" method="post" style="display:grid; gap:10px;">
            <input type="text" name="vessel_name" placeholder="Nom du navire" required style="padding:8px; border:none; border-radius:4px;">
            <input type="number" step="0.01" name="weekly_cost" placeholder="Coût hebdomadaire (FCFA)" required style="padding:8px; border:none; border-radius:4px;">
            <input type="number" step="0.01" name="fuel_price_per_ton" placeholder="Prix fuel par tonne (FCFA)" required style="padding:8px; border:none; border-radius:4px;">
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer
            </button>
        </form>
    </div>

    <!-- Liste des navires -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📋 Liste des navires et OPEX</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
            <thead>
                <tr style="background:#334155; color:white;">
                    <th style="padding:8px; text-align:left;">ID</th>
                    <th style="padding:8px; text-align:left;">Navire</th>
                    <th style="padding:8px; text-align:left;">Coût hebdo (FCFA)</th>
                    <th style="padding:8px; text-align:left;">Prix fuel/tonne (FCFA)</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($opex_list) > 0): ?>
                    <?php foreach ($opex_list as $o): ?>
                    <tr style="border-bottom:1px solid #1e293b;">
                        <td style="padding:8px;"><?= $o['id'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($o['vessel_name']) ?></td>
                        <td style="padding:8px;"><?= number_format($o['weekly_cost'], 0, ',', ' ') ?></td>
                        <td style="padding:8px;"><?= number_format($o['fuel_price_per_ton'], 0, ',', ' ') ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="padding:8px; text-align:center; color:#94a3b8;">Aucun navire enregistré</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
