<?php
$ROOT = dirname(__DIR__, 2);

require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

require_once $ROOT . '/dompdf-3.1.0/dompdf/vendor/autoload.php';
use Dompdf\Dompdf;

$pdo = getDbConnection();

// ====== Dernier KPI depuis la table kpis ======
$last_kpi = $pdo->query("SELECT * FROM kpis ORDER BY calculated_at DESC LIMIT 1")->fetch(PDO::FETCH_ASSOC);

// Valeurs brutes
$coutRotation = $last_kpi ? (float)$last_kpi['cost_rotation'] : 0;
$seuilRentabilite = $last_kpi ? (float)$last_kpi['breakeven_volume'] : 0;
$prixMoyenConcurrent = $last_kpi ? (float)$last_kpi['competitor_avg_price'] : 0;
$scoreFaisabilite = $last_kpi ? (float)$last_kpi['feasibility_score'] : 0;

// Stats d’avancement
$portsEnquetes = (int) $pdo->query("SELECT COUNT(DISTINCT p.id) FROM ports p JOIN port_costs pc ON pc.port_id = p.id")->fetchColumn();
$clientsEnquetes = (int) $pdo->query("SELECT COUNT(DISTINCT c.id) FROM clients c JOIN demands d ON d.client_id = c.id")->fetchColumn();
$concurrents = (int) $pdo->query("SELECT COUNT(*) FROM competitors")->fetchColumn();
$totalPorts = (int) $pdo->query("SELECT COUNT(*) FROM ports")->fetchColumn();
$totalClients = (int) $pdo->query("SELECT COUNT(*) FROM clients")->fetchColumn();
$totalPossible = max(0, $totalPorts + $totalClients);
$avancementGlobal = $totalPossible > 0 ? round((($portsEnquetes + $clientsEnquetes) / $totalPossible) * 100) : 0;

// ====== Recommandations ======
$reco = [];
if ($coutRotation > 0 && $prixMoyenConcurrent > 0) {
    $margeRel = ($prixMoyenConcurrent - $coutRotation) / $coutRotation;
    $margePct = round($margeRel * 100);

    if ($margeRel >= 0.15) {
        $reco[] = "Marge confortable (&asymp; " . $margePct . "%) &rarr; Prioriser la prospection.";
    } elseif ($margeRel > 0) {
        $reco[] = "Marge faible (" . $margePct . "%) &rarr; Négocier les coûts ou optimiser l’OPEX.";
    } else {
        $reco[] = "Prix concurrent &le; coût de rotation &rarr; Réétudier le pricing ou les routes.";
    }
} else {
    $reco[] = "Saisir au moins un coût portuaire et un prix concurrent.";
}
if ($avancementGlobal < 50) $reco[] = "Accélérer les enquêtes pour fiabiliser les KPIs.";
if ($portsEnquetes === 0)   $reco[] = "Aucun port avec coûts renseignés.";
if ($clientsEnquetes === 0) $reco[] = "Aucun client avec demande.";
if ($concurrents === 0)     $reco[] = "Aucun concurrent saisi.";

// ====== HTML PDF ======
$html = '
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: "DejaVu Sans", sans-serif; font-size: 12px; color: #0f172a; }
h1 { color: #38bdf8; text-align:center; font-size: 20px; }
h2 { color: #38bdf8; margin-top:20px; }
table { width: 100%; border-collapse: collapse; margin-top: 10px; }
th, td { border: 1px solid #ccc; padding: 8px; text-align: left; vertical-align: top; }
th { background: #38bdf8; color: white; }
ul { margin: 0; padding-left: 20px; }
.bar-container { background: #e5e7eb; border-radius: 4px; overflow: hidden; height: 10px; }
.bar-fill { height: 100%; background: #38bdf8; }
.footer { margin-top: 30px; font-size: 0.8rem; text-align:center; color:#555; }
a { color: #38bdf8; text-decoration: none; }
.small { color:#374151; font-size: 11px; }
</style>
</head>
<body>

<h1>Rapport KPIs - Baltic Trader</h1>

<!-- Sommaire -->
<h2>Sommaire</h2>
<ul>
    <li><a href="#kpi">1. Indicateurs clés</a></li>
    <li><a href="#methodes">2. Méthodes de calcul</a></li>
    <li><a href="#reco">3. Recommandations</a></li>
</ul>

<!-- Section KPI -->
<h2 id="kpi">1. Indicateurs clés (Dernier calcul)</h2>
<table>
<tr><th>KPI</th><th>Valeur</th><th>Progression</th></tr>
<tr><td>Coût de rotation</td><td>' . number_format($coutRotation, 0, ',', ' ') . ' FCFA</td><td></td></tr>
<tr><td>Seuil de rentabilité</td><td>' . number_format($seuilRentabilite, 2, ',', ' ') . ' tonnes</td><td></td></tr>
<tr><td>Prix moyen concurrent</td><td>' . number_format($prixMoyenConcurrent, 0, ',', ' ') . ' FCFA/t</td><td></td></tr>
<tr>
    <td>Score de faisabilité</td>
    <td>' . number_format($scoreFaisabilite, 2, ',', ' ') . '/100</td>
    <td><div class="bar-container"><div class="bar-fill" style="width:' . max(0, min(100, (float)$scoreFaisabilite)) . '%"></div></div></td>
</tr>
<tr>
    <td>Ports enquêtés</td>
    <td>' . $portsEnquetes . ' / ' . $totalPorts . '</td>
    <td><div class="bar-container"><div class="bar-fill" style="width:' . ($totalPorts>0?round(($portsEnquetes/$totalPorts*100),2):0) . '%"></div></div></td>
</tr>
<tr>
    <td>Clients enquêtés</td>
    <td>' . $clientsEnquetes . ' / ' . $totalClients . '</td>
    <td><div class="bar-container"><div class="bar-fill" style="width:' . ($totalClients>0?round(($clientsEnquetes/$totalClients*100),2):0) . '%"></div></div></td>
</tr>
<tr>
    <td>Concurrents</td>
    <td>' . $concurrents . '</td>
    <td></td>
</tr>
<tr>
    <td>Avancement global</td>
    <td>' . $avancementGlobal . '%</td>
    <td><div class="bar-container"><div class="bar-fill" style="width:' . $avancementGlobal . '%"></div></div></td>
</tr>
</table>

<p class="small">Source des valeurs KPI ci-dessus : table kpis (dernier enregistrement par date de calcul).</p>

<!-- Section Méthodes -->
<h2 id="methodes">2. Méthodes de calcul des KPI</h2>
<table>
<tr><th>KPI</th><th>Explication</th><th>Formule</th><th>Source données</th></tr>
<tr>
<td>Coût de rotation</td>
<td>Coût total d\'une rotation complète du navire, incluant frais d\'escale, OPEX et carburant.</td>
<td>CoûtRotation = &Sigma;(FraisEscale_p) + (OPEX_hebdo &times; SemainesRotation) + (Conso_totale &times; Prix_fuel)</td>
<td>port_costs.amount, vessel_opex.weekly_cost, vessel_opex.fuel_price_per_ton, pilot_journal</td>
</tr>
<tr>
<td>Seuil de rentabilité</td>
<td>Volume minimal à transporter pour couvrir les coûts fixes.</td>
<td>Q* = CoûtsFixesParRotation / (PrixMoyenUnité - CoûtVariableUnitaire)</td>
<td>kpis.cost_rotation, demands.price_expected, port_costs, vessel_opex</td>
</tr>
<tr>
<td>Prix moyen concurrent</td>
<td>Prix moyen du marché pour la même route.</td>
<td>PrixMoyenConcurrent = &Sigma;(Prix_i) / n</td>
<td>competitor_prices.price, competitors.id</td>
</tr>
<tr>
<td>Score de faisabilité</td>
<td>Indice global de viabilité basé sur plusieurs critères pondérés.</td>
<td>Score = w1 &times; Attractivité + w2 &times; AvantagePrix + w3 &times; AccèsPortuaire + w4 &times; RisqueRéglementaire + w5 &times; Robustesse</td>
<td>demands.volume, competitor_prices, ports.draft_limit, regulations.status, pilot_journal</td>
</tr>
</table>

<!-- Section Recommandations -->
<h2 id="reco">3. Recommandations</h2>
<ul>';
foreach ($reco as $r) {
    $html .= '<li>' . $r . '</li>';
}
$html .= '</ul>

<div class="footer">Généré automatiquement le ' . date('d/m/Y H:i') . '</div>
</body>
</html>
';

// ====== Génération du PDF ======
$dompdf = new Dompdf();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("kpis_baltic_trader.pdf", ["Attachment" => true]);
exit;
