<?php
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

// Récupération des concurrents avec nombre de prix
$competitors = $pdo->query("
    SELECT comp.id, comp.NAME, COUNT(cp.id) AS nb_prix
    FROM competitors comp
    LEFT JOIN competitor_prices cp ON cp.competitor_id = comp.id
    GROUP BY comp.id
    ORDER BY comp.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Récupération des ports pour les listes déroulantes
$ports = $pdo->query("SELECT id, NAME FROM ports ORDER BY NAME ASC")->fetchAll(PDO::FETCH_ASSOC);

// Récupération des prix concurrents avec détails
$prices = $pdo->query("
    SELECT cp.id, comp.NAME AS competitor_name, po.NAME AS origin_port, pd.NAME AS dest_port, cp.price
    FROM competitor_prices cp
    JOIN competitors comp ON comp.id = cp.competitor_id
    JOIN ports po ON po.id = cp.origin_port_id
    JOIN ports pd ON pd.id = cp.dest_port_id
    ORDER BY cp.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../partials/header.php';
?>

<div style="padding:20px; color:white; font-family:Arial, sans-serif;">
    <h2 style="color:#38bdf8; margin-bottom:15px;">📊 Gestion de la Concurrence</h2>
    <?php if (!empty($_SESSION['success_message'])): ?>
        <div style="background:#16a34a; color:white; padding:10px; border-radius:4px; margin-bottom:15px;">
            <?= $_SESSION['success_message']; ?>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
    <a href="<?= $basePath; ?>/../public/dashboard" 
    style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#38bdf8; color:#0f172a; font-weight:bold; border-radius:4px; text-decoration:none;">
        ⬅ Retour au Dashboard
    </a>
    <!-- Formulaire ajout concurrent -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un concurrent</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_competitor.php" method="post" style="display:grid; gap:10px;">
            <input type="text" name="NAME" placeholder="Nom du concurrent" required style="padding:8px; border:none; border-radius:4px;">
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer le concurrent
            </button>
        </form>
    </div>

    <!-- Formulaire ajout prix concurrent -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un prix concurrent</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_competitor_price.php" method="post" style="display:grid; gap:10px;">
            <select name="competitor_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Sélectionner un concurrent --</option>
                <?php foreach ($competitors as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <select name="origin_port_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Port d'origine --</option>
                <?php foreach ($ports as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <select name="dest_port_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Port de destination --</option>
                <?php foreach ($ports as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <input type="number" step="0.01" name="price" placeholder="Prix (FCFA/t)" required style="padding:8px; border:none; border-radius:4px;">

            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer le prix
            </button>
        </form>
    </div>

    <!-- Liste des concurrents -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📋 Liste des concurrents</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden; margin-bottom:30px;">
                <thead>
                    <tr style="background:#334155; color:white;">
                        <th style="padding:8px; text-align:left;">ID</th>
                        <th style="padding:8px; text-align:left;">Nom</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($competitors) > 0): ?>
                        <?php foreach ($competitors as $c): ?>
                        <tr style="border-bottom:1px solid #1e293b;">
                            <td style="padding:8px;"><?= $c['id'] ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($c['NAME']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" style="padding:8px; text-align:center; color:#94a3b8;">Aucun concurrent enregistré</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
        </table>
    </div>
    

    <!-- Liste des prix concurrents -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">💰 Liste des prix concurrents</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
                <thead>
                    <tr style="background:#334155; color:white;">
                        <th style="padding:8px; text-align:left;">ID</th>
                        <th style="padding:8px; text-align:left;">Concurrent</th>
                        <th style="padding:8px; text-align:left;">Port origine</th>
                        <th style="padding:8px; text-align:left;">Port destination</th>
                        <th style="padding:8px; text-align:left;">Prix (FCFA/t)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($prices) > 0): ?>
                        <?php foreach ($prices as $p): ?>
                        <tr style="border-bottom:1px solid #1e293b;">
                            <td style="padding:8px;"><?= $p['id'] ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($p['competitor_name']) ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($p['origin_port']) ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($p['dest_port']) ?></td>
                            <td style="padding:8px;"><?= number_format($p['price'], 0, ',', ' ') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="padding:8px; text-align:center; color:#94a3b8;">Aucun prix enregistré</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
