<?php
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

// Récupération des clients avec nombre de demandes
$clients = $pdo->query("
    SELECT c.id, c.NAME, c.contact, COUNT(d.id) AS nb_demandes
    FROM clients c
    LEFT JOIN demands d ON d.client_id = c.id
    GROUP BY c.id
    ORDER BY c.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Récupération des ports pour les listes déroulantes
$ports = $pdo->query("SELECT id, NAME FROM ports ORDER BY NAME ASC")->fetchAll(PDO::FETCH_ASSOC);

// Récupération des demandes avec détails
$demands = $pdo->query("
    SELECT d.id, c.NAME AS client_name, po.NAME AS origin_port, pd.NAME AS dest_port,
           d.volume, d.unit, d.price_expected
    FROM demands d
    JOIN clients c ON c.id = d.client_id
    JOIN ports po ON po.id = d.origin_port_id
    JOIN ports pd ON pd.id = d.dest_port_id
    ORDER BY d.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../partials/header.php';
?>
<div style="padding:20px; color:white; font-family:Arial, sans-serif;">
    <h2 style="color:#38bdf8; margin-bottom:15px;">👥 Gestion des Clients & Demandes</h2>
    <?php if (!empty($_SESSION['success_message'])): ?>
        <div style="background:#16a34a; color:white; padding:10px; border-radius:4px; margin-bottom:15px;">
            <?= $_SESSION['success_message']; ?>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
<a href="<?= $basePath; ?>/../public/dashboard" 
    style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#38bdf8; color:#0f172a; font-weight:bold; border-radius:4px; text-decoration:none;">
        ⬅ Retour au Dashboard
    </a>
    <!-- Formulaire ajout client -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter un client</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_client.php" method="post" style="display:grid; gap:10px;">
            <input type="text" name="NAME" placeholder="Nom du client" required style="padding:8px; border:none; border-radius:4px;">
            <input type="text" name="contact" placeholder="Contact (email ou téléphone)" style="padding:8px; border:none; border-radius:4px;">
            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer le client
            </button>
        </form>
    </div>

    <!-- Formulaire ajout demande -->
    <div style="background:#1e293b; padding:20px; border-radius:8px; margin-bottom:25px;">
        <h3 style="color:#38bdf8; margin-bottom:10px;">➕ Ajouter une demande</h3>
        <form action="<?= $basePath; ?>/modules/action_insert/insert_demand.php" method="post" style="display:grid; gap:10px;">
            <select name="client_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Sélectionner un client --</option>
                <?php foreach ($clients as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <select name="origin_port_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Port d'origine --</option>
                <?php foreach ($ports as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <select name="dest_port_id" required style="padding:8px; border:none; border-radius:4px;">
                <option value="">-- Port de destination --</option>
                <?php foreach ($ports as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['NAME']) ?></option>
                <?php endforeach; ?>
            </select>

            <input type="number" step="0.01" name="volume" placeholder="Volume" required style="padding:8px; border:none; border-radius:4px;">
            <input type="text" name="unit" placeholder="Unité (tonne, TEU, m3...)" required style="padding:8px; border:none; border-radius:4px;">
            <input type="number" step="0.01" name="price_expected" placeholder="Prix attendu" required style="padding:8px; border:none; border-radius:4px;">

            <button type="submit" style="padding:10px; background:#38bdf8; color:#0f172a; font-weight:bold; border:none; border-radius:4px; cursor:pointer;">
                Enregistrer la demande
            </button>
        </form>
    </div>

    <!-- Liste des clients -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📋 Liste des clients</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden; margin-bottom:30px;">
            <thead>
                <tr style="background:#334155; color:white;">
                    <th style="padding:8px; text-align:left;">ID</th>
                    <th style="padding:8px; text-align:left;">Nom</th>
                    <th style="padding:8px; text-align:left;">Contact</th>
                    <th style="padding:8px; text-align:left;">Nb Demandes</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($clients) > 0): ?>
                    <?php foreach ($clients as $c): ?>
                    <tr style="border-bottom:1px solid #1e293b;">
                        <td style="padding:8px;"><?= $c['id'] ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($c['NAME']) ?></td>
                        <td style="padding:8px;"><?= htmlspecialchars($c['contact']) ?></td>
                        <td style="padding:8px;"><?= $c['nb_demandes'] ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="padding:8px; text-align:center; color:#94a3b8;">Aucun client enregistré</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    

    <!-- Liste des demandes -->
    <h3 style="color:#38bdf8; margin-bottom:10px;">📦 Liste des demandes</h3>
    <div style="overflow-x:auto; max-width:100%;">
        <table style="width:100%; border-collapse:collapse; background:#0f172a; border-radius:6px; overflow:hidden;">
                <thead>
                    <tr style="background:#334155; color:white;">
                        <th style="padding:8px; text-align:left;">ID</th>
                        <th style="padding:8px; text-align:left;">Client</th>
                        <th style="padding:8px; text-align:left;">Port origine</th>
                        <th style="padding:8px; text-align:left;">Port destination</th>
                        <th style="padding:8px; text-align:left;">Volume</th>
                        <th style="padding:8px; text-align:left;">Unité</th>
                        <th style="padding:8px; text-align:left;">Prix attendu</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($demands) > 0): ?>
                        <?php foreach ($demands as $d): ?>
                        <tr style="border-bottom:1px solid #1e293b;">
                            <td style="padding:8px;"><?= $d['id'] ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($d['client_name']) ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($d['origin_port']) ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($d['dest_port']) ?></td>
                            <td style="padding:8px;"><?= $d['volume'] ?></td>
                            <td style="padding:8px;"><?= htmlspecialchars($d['unit']) ?></td>
                                                <td style="padding:8px;"><?= $d['price_expected'] !== null ? number_format($d['price_expected'], 0, ',', ' ') : '-' ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" style="padding:8px; text-align:center; color:#94a3b8;">Aucune demande enregistrée</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
