<?php
$ROOT = dirname(__DIR__, 3); // modules/action_insert → racine projet
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

$port_id = (int)($_POST['port_id'] ?? 0);
$cost_type = trim($_POST['cost_type'] ?? '');
$amount = $_POST['amount'] !== '' ? (float)$_POST['amount'] : null;
$unit = trim($_POST['unit'] ?? '');

if ($port_id <= 0 || $cost_type === '' || $amount === null) {
    die("Tous les champs obligatoires doivent être remplis");
}

$stmt = $pdo->prepare("
    INSERT INTO port_costs (port_id, cost_type, amount, unit)
    VALUES (:port_id, :cost_type, :amount, :unit)
");
$stmt->execute([
    ':port_id' => $port_id,
    ':cost_type' => $cost_type,
    ':amount' => $amount,
    ':unit' => $unit
]);

$_SESSION['success_message'] = "✅ Coût ajouté avec succès";
header("Location: ../ports.php");
exit;
