<?php
$ROOT = dirname(__DIR__, 3); // modules/action_insert → racine projet
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

$name = trim($_POST['NAME'] ?? '');
$code = trim($_POST['CODE'] ?? '');
$location = trim($_POST['location'] ?? '');
$draft_limit = $_POST['draft_limit'] !== '' ? (float)$_POST['draft_limit'] : null;
$notes = trim($_POST['notes'] ?? '');

if ($name === '') {
    die("Nom du port obligatoire");
}

$stmt = $pdo->prepare("
    INSERT INTO ports (NAME, CODE, location, draft_limit, notes)
    VALUES (:name, :code, :location, :draft_limit, :notes)
");
$stmt->execute([
    ':name' => $name,
    ':code' => $code,
    ':location' => $location,
    ':draft_limit' => $draft_limit,
    ':notes' => $notes
]);

// On définit une variable de session pour afficher le message
$_SESSION['success_message'] = "✅ Enregistrement réussi !";

// Retour direct à la page précédente
header("Location: ../ports.php");
exit;
