<?php
$ROOT = dirname(__DIR__, 3);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

$route_desc = trim($_POST['route_desc'] ?? '');
$date_start = $_POST['date_start'] ?? '';
$date_end = $_POST['date_end'] ?? '';
$notes = trim($_POST['notes'] ?? '');

if ($route_desc === '' || $date_start === '' || $date_end === '') {
    die("Tous les champs obligatoires doivent être remplis");
}

$stmt = $pdo->prepare("
    INSERT INTO pilot_journal (route_desc, date_start, date_end, notes)
    VALUES (:route_desc, :date_start, :date_end, :notes)
");
$stmt->execute([
    ':route_desc' => $route_desc,
    ':date_start' => $date_start,
    ':date_end' => $date_end,
    ':notes' => $notes
]);

$_SESSION['success_message'] = "✅ Enregistrement réussi !";

// Retour direct à la page précédente
header("Location: ../pilot_journal.php");
exit;
