<?php
$ROOT = dirname(__DIR__, 3);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

$vessel_name = trim($_POST['vessel_name'] ?? '');
$weekly_cost = $_POST['weekly_cost'] !== '' ? (float)$_POST['weekly_cost'] : null;
$fuel_price_per_ton = $_POST['fuel_price_per_ton'] !== '' ? (float)$_POST['fuel_price_per_ton'] : null;

if ($vessel_name === '' || $weekly_cost === null || $fuel_price_per_ton === null) {
    die("Tous les champs sont obligatoires");
}

$stmt = $pdo->prepare("
    INSERT INTO vessel_opex (vessel_name, weekly_cost, fuel_price_per_ton)
    VALUES (:vessel_name, :weekly_cost, :fuel_price_per_ton)
");
$stmt->execute([
    ':vessel_name' => $vessel_name,
    ':weekly_cost' => $weekly_cost,
    ':fuel_price_per_ton' => $fuel_price_per_ton
]);

$_SESSION['success_message'] = "✅ Enregistrement réussi !";

// Retour direct à la page précédente
header("Location: ../opex.php");
exit;
