<?php
$ROOT = dirname(__DIR__, 3); // modules/action_calcul → modules → public → racine projet
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/src/lib/session.php';
require_auth();

$pdo = getDbConnection();

/* ============================
   1️⃣ FRAIS ESCALE PAR PORT
============================ */
$sql_frais = "
    SELECT port_id, SUM(amount) AS total_frais
    FROM port_costs
    GROUP BY port_id
";
$frais_ports = $pdo->query($sql_frais)->fetchAll(PDO::FETCH_KEY_PAIR); // [port_id => total_frais]

/* ============================
   2️⃣ OPEX NAVIRE & CARBURANT
============================ */
$opex = $pdo->query("SELECT weekly_cost, fuel_price_per_ton FROM vessel_opex LIMIT 1")->fetch(PDO::FETCH_ASSOC);
$opex_weekly = (float)($opex['weekly_cost'] ?? 0);
$fuel_price_per_ton = (float)($opex['fuel_price_per_ton'] ?? 0);

// Durée rotation réelle = moyenne des rotations dans pilot_journal
$sql_duree = "
    SELECT AVG(DATEDIFF(date_end, date_start) / 7) AS semaines
    FROM pilot_journal
";
$semaines_rotation = (float)$pdo->query($sql_duree)->fetchColumn();
if ($semaines_rotation <= 0) $semaines_rotation = 4; // fallback

// Consommation carburant réelle = moyenne estimée (exemple : 500 tonnes par rotation)
$sql_conso = "
    SELECT AVG(volume) FROM demands
";
$volume_moyen = (float)$pdo->query($sql_conso)->fetchColumn();
$tonnes_carburant = max(1, $volume_moyen * 0.05); // ex: 5% du volume en tonnes de fuel
$carburant_rotation = $tonnes_carburant * $fuel_price_per_ton;

/* ============================
   3️⃣ COÛT ROTATION
============================ */
$cout_rotation = array_sum($frais_ports) + ($opex_weekly * $semaines_rotation) + $carburant_rotation;

/* ============================
   4️⃣ PRIX MOYEN PAR UNITÉ
============================ */
$sql_prix_moyen = "SELECT AVG(price_expected) FROM demands WHERE price_expected IS NOT NULL";
$prix_moyen_unite = (float) $pdo->query($sql_prix_moyen)->fetchColumn();

/* ============================
   5️⃣ COÛT VARIABLE UNITAIRE
============================ */
// Carburant par unité
$carburant_unitaire = $fuel_price_per_ton * 0.05; // 5% d'une tonne par unité
// Manutention variable = moyenne des coûts 'manutention' dans port_costs
$sql_manut = "
    SELECT AVG(amount) FROM port_costs WHERE LOWER(cost_type) LIKE '%manutention%'
";
$manutention_variable = (float)$pdo->query($sql_manut)->fetchColumn();
$cout_variable_unitaire = $carburant_unitaire + $manutention_variable;

/* ============================
   6️⃣ SEUIL DE RENTABILITÉ (volume)
============================ */
$breakeven_volume = 0;
if (($prix_moyen_unite - $cout_variable_unitaire) > 0) {
    $breakeven_volume = $cout_rotation / ($prix_moyen_unite - $cout_variable_unitaire);
}

/* ============================
   7️⃣ PRIX MOYEN CONCURRENT
============================ */
$sql_prix_concurrent = "SELECT AVG(price) FROM competitor_prices";
$prix_moyen_concurrent = (float) $pdo->query($sql_prix_concurrent)->fetchColumn();

/* ============================
   8️⃣ AVANTAGE PRIX
============================ */
$avantage_prix = 0;
if ($prix_moyen_concurrent > 0) {
    $avantage_prix = max(0, 100 - (($prix_moyen_unite - $prix_moyen_concurrent) / $prix_moyen_concurrent) * 100);
}

/* ============================
   9️⃣ SCORE FAISABILITÉ
============================ */
// AttractivitéDemande = min(100, (VolumeDemande / CapacitéRotation) × 100)
$sql_volume_total = "SELECT SUM(volume) FROM demands";
$volume_total = (float)$pdo->query($sql_volume_total)->fetchColumn();
$capacite_rotation = $volume_moyen * $semaines_rotation; // estimation
$attractivite_demande = min(100, ($capacite_rotation > 0 ? ($volume_total / $capacite_rotation) * 100 : 0));

// AccèsPortuaire = 100 - contraintes (tirant d’eau > 12m = pénalité)
$sql_tirant = "SELECT AVG(draft_limit) FROM ports WHERE draft_limit IS NOT NULL";
$moy_tirant = (float)$pdo->query($sql_tirant)->fetchColumn();
$acces_portuaire = 100 - max(0, ($moy_tirant < 12 ? (12 - $moy_tirant) * 2 : 0));

// RisqueRéglementaire = 100 - % de statuts non 'actif'
$sql_reg = "SELECT COUNT(*) AS total, SUM(CASE WHEN STATUS != 'actif' THEN 1 ELSE 0 END) AS non_actifs FROM regulations";
$reg_data = $pdo->query($sql_reg)->fetch(PDO::FETCH_ASSOC);
$risque_reglementaire = 100 - (($reg_data['total'] > 0 ? ($reg_data['non_actifs'] / $reg_data['total']) * 100 : 0));

// RobustesseOpérationnelle = basé sur nombre de rotations dans pilot_journal
$sql_rotations = "SELECT COUNT(*) FROM pilot_journal";
$nb_rotations = (int)$pdo->query($sql_rotations)->fetchColumn();
$robustesse_operationnelle = min(100, $nb_rotations * 10);

// Pondérations
$w1 = 0.3; $w2 = 0.25; $w3 = 0.2; $w4 = 0.15; $w5 = 0.1;

$score_faisabilite = 
    $w1 * $attractivite_demande +
    $w2 * $avantage_prix +
    $w3 * $acces_portuaire +
    $w4 * $risque_reglementaire +
    $w5 * $robustesse_operationnelle;

/* ============================
   🔟 INSERTION DANS KPIS
============================ */
$stmt = $pdo->prepare("
    INSERT INTO kpis (cost_rotation, breakeven_volume, competitor_avg_price, feasibility_score)
    VALUES (:cost_rotation, :breakeven_volume, :competitor_avg_price, :feasibility_score)
");
$stmt->execute([
    ':cost_rotation' => $cout_rotation,
    ':breakeven_volume' => $breakeven_volume,
    ':competitor_avg_price' => $prix_moyen_concurrent,
    ':feasibility_score' => $score_faisabilite
]);

$_SESSION['success_message'] = "✅ KPI recalculés avec données réelles";
header("Location: ../../dashboard.php");
exit;
