<?php
require_once __DIR__ . '/src/lib/session.php';

// Détecter automatiquement le chemin du projet (ex: /baltic_trader)
$scriptName = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
$basePath = rtrim($scriptName, '/');

// Vérifier si l'utilisateur est connecté
$user = current_user();

// Construire l'URL de redirection
$redirectUrl = $user ? "$basePath/public/dashboard" : "$basePath/public/login";
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>BALTIC TRADER — Chargement</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Ccircle cx='50' cy='50' r='45' fill='%231e40af'/%3E%3Cpath d='M30 45 L50 25 L70 45 L65 50 L50 35 L35 50 Z' fill='white'/%3E%3Crect x='25' y='50' width='50' height='25' rx='5' fill='white'/%3E%3Ctext x='50' y='68' text-anchor='middle' fill='%231e40af' font-size='14' font-family='Arial, sans-serif'%3ECG%3C/text%3E%3C/svg%3E">
    
<style>
/* Reset */
* { margin: 0; padding: 0; box-sizing: border-box; }

/* Fond animé */
body, html {
    height: 100%;
    font-family: Arial, sans-serif;
    overflow: hidden;
    background: linear-gradient(#0f172a, #1e293b);
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
}

/* Vagues */
.wave {
    position: absolute;
    bottom: 0;
    width: 200%;
    height: 100px;
    background: rgba(56, 189, 248, 0.3);
    border-radius: 1000% 1000% 0 0;
    animation: waveAnim 6s linear infinite;
}
.wave:nth-child(2) {
    bottom: 10px;
    background: rgba(56, 189, 248, 0.5);
    animation: waveAnim 8s linear infinite reverse;
}
.wave:nth-child(3) {
    bottom: 20px;
    background: rgba(56, 189, 248, 0.7);
    animation: waveAnim 10s linear infinite;
}

@keyframes waveAnim {
    0% { transform: translateX(0); }
    100% { transform: translateX(-50%); }
}

/* Contenu central */
.loader-container {
    text-align: center;
    z-index: 10;
    animation: fadeIn 1s ease-in-out;
    padding: 0 10px;
}

.loader-title {
    font-size: clamp(1.5rem, 5vw, 2.5rem);
    font-weight: bold;
    letter-spacing: 2px;
    margin-bottom: 20px;
    color: #38bdf8;
    text-shadow: 0 0 10px rgba(56,189,248,0.7);
}

/* Icônes animées */
.icons {
    display: flex;
    justify-content: center;
    gap: 15px;
    margin-bottom: 20px;
}

.icon {
    font-size: clamp(1.5rem, 6vw, 2.5rem);
    animation: bounce 1.2s infinite;
}
.icon:nth-child(2) { animation-delay: 0.2s; }
.icon:nth-child(3) { animation-delay: 0.4s; }

/* Barre de progression */
.progress-bar {
    width: 60%;
    max-width: 250px;
    height: 8px;
    background: #1e293b;
    border-radius: 4px;
    overflow: hidden;
    margin: 0 auto;
}
.progress-fill {
    height: 100%;
    width: 0;
    background: #38bdf8;
    animation: fillBar 2.5s forwards;
}

/* Boutons */
.buttons {
    margin-top: 20px;
    display: flex;
    justify-content: center;
    gap: 10px;
}
.btn {
    padding: 10px 15px;
    font-size: clamp(0.9rem, 3vw, 1rem);
    border: none;
    border-radius: 5px;
    background: #38bdf8;
    color: #0f172a;
    font-weight: bold;
    cursor: pointer;
    text-decoration: none;
}
.btn:hover {
    background: #0ea5e9;
}

/* Animations */
@keyframes bounce {
    0%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-10px); }
}
@keyframes fillBar {
    to { width: 100%; }
}
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

/* Mobile */
@media (max-width: 480px) {
    .icons { gap: 10px; }
    .progress-bar { height: 6px; }
}
</style>
</head>
<body>
<!-- Vagues -->
<div class="wave"></div>
<div class="wave"></div>
<div class="wave"></div>

<!-- Contenu -->
<div class="loader-container">
    <div class="loader-title">⚓ BALTIC TRADER 🚢</div>
    <div class="icons">
        <div class="icon">⚓</div>
        <div class="icon">🚢</div>
        <div class="icon">🌊</div>
    </div>
    <div class="progress-bar">
        <div class="progress-fill"></div>
    </div>
    <div class="buttons">
        <a href="<?php echo $basePath; ?>/public/login" class="btn">Connexion</a>
        <a href="<?php echo $basePath; ?>/public/register" class="btn">Inscription</a>
    </div>
</div>

<script>
// Redirection automatique après 4,2 secondes
setTimeout(function() {
    window.location.href = "<?php echo $redirectUrl; ?>";
}, 4200);
</script>
</body>
</html>
