// assets/js/common.js

// Dépendances : Assurez-vous que l'API_BASE est définie avant d'appeler cette fonction
// Si API_BASE est déclarée dans chaque page, il faudra passer l'URL en paramètre ou la déclarer globalement.
// Pour cet exemple, on suppose que API_BASE est déclarée dans le scope global ou dans le script HTML principal.
// De plus, on suppose que la fonction 'el' (document.getElementById) est définie dans le script appelant.

// Récupère l'élément par ID - si vous ne voulez pas la dépendance 'el'
const getEl = id => document.getElementById(id);

/**
 * Gère le processus de déconnexion de l'utilisateur.
 * @param {string} apiBase L'URL de base de l'API (ex: '/DailyReportsemorhc/api').
 * @param {string} loginPage La page de redirection après déconnexion (ex: 'index.html').
 */
async function logout(apiBase, loginPage = 'index.html') {
  try {
    // 1. Notifier le serveur de la déconnexion
    // La fonction wrapFetch() (dans vos pages) ajoutera le token d'authentification.
    await fetch(`${apiBase}/logout`, { method: 'POST' });
  } catch (e) {
    // Erreur réseau ignorée pour ne pas bloquer la déconnexion locale
    console.error("Erreur lors de l'appel API de déconnexion:", e);
  } finally {
    // 2. Nettoyage du stockage local (essentiel)
    localStorage.clear();
    // 3. Redirection
    alert("Vous avez été déconnecté.");
    window.location.replace(loginPage); 
  }
}

// Fonction pour lier le gestionnaire d'événement de déconnexion
function setupLogout(apiBase, loginPage = 'index.html', btnId = 'btnLogout') {
    const btn = getEl(btnId);
    if (btn) {
        btn.addEventListener('click', () => logout(apiBase, loginPage));
    }
}