console.log("auth.js chargé !");

async function handleLogout(e) {
    // Empêche le rechargement automatique du bouton submit
    if (e) e.preventDefault();

    console.log("handleLogout() déclenché !");
    const token = localStorage.getItem('token');

    try {
        if (token) {
            console.log("Token trouvé:", token);

            const res = await fetch('/api/logout', {
                method: 'POST',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Content-Type': 'application/json'
                }
            });

            const data = await res.json().catch(()=>({}));
            console.log("Réponse logout:", res.status, data);
        } else {
            console.warn("⚠️ Aucun token trouvé dans localStorage");
        }
    } catch (e) {
        console.error("Erreur logout:", e);
    } finally {
        // Nettoyage local + redirection
        localStorage.clear();
        location.replace('index.html');
    }
}

document.addEventListener('DOMContentLoaded', ()=>{
    const btn = document.getElementById('btnLogout');
    if (btn) {
        console.log("Bouton logout trouvé:", btn);
        btn.addEventListener('click', handleLogout);
    } else {
        console.error("⚠️ Aucun bouton #btnLogout trouvé !");
    }
});
