(function() {
    const userToken = localStorage.getItem('userToken');
    const userDataString = localStorage.getItem('userData');

    // Si pas connecté → retour login
    if (!userToken || !userDataString) {
        alert("Accès refusé. Veuillez vous connecter.");
        window.location.replace('/client/index.html'); 
        return;
    }

    try {
        const userData = JSON.parse(userDataString);
        const currentPage = window.location.pathname.split('/').pop();
        const userRole = userData.nom_role.toLowerCase();

        // ✅ Définition des pages autorisées par rôle
        const rolePages = {
            'admin': [
                'dashboard.html',
                'caisseadmin.html',
                'fournisseursadmin.html',
                'avancesadmin.html',
                'utilisateursadmin.html'
            ],
            'sursite': [
                'sitedash.html',
                'pesage.html',
                'expedition.html',
                'caisse.html',
                'fournisseurs.html',
                'avances.html'
                // ajoute ici tous les futurs modules sursite
            ],
            'surdepot': [
                'depotdash.html',
                'recepfour.html',
                'analyse.html'
                // ajoute ici tous les futurs modules surdepot
            ]
        };

        // Vérifie si la page actuelle est autorisée
        if (rolePages[userRole] && !rolePages[userRole].includes(currentPage)) {
            alert(`Votre rôle de '${userRole}' ne vous autorise pas à voir cette page. Vous allez être redirigé.`);
            // Redirige vers la première page autorisée du rôle
            window.location.replace(rolePages[userRole][0]);
        }

    } catch (e) {
        console.error("Erreur lors de la lecture des données utilisateur.", e);
        localStorage.clear();
        window.location.replace('/client/index.html');
    }
})();
