<?php
class Response {
    public static function json(array $data, int $statusCode = 200): void {
        http_response_code($statusCode);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }

    public static function success($data = [], string $message = 'Opération réussie.', int $statusCode = 200): void {
        self::json(['success'=>true,'message'=>$message,'data'=>$data], $statusCode);
    }

    public static function error(string $message, int $statusCode = 400): void {
        self::json(['success'=>false,'message'=>$message], $statusCode);
    }

    public static function unauthorized(string $message = 'Authentification requise.'): void {
        self::error($message, 401);
    }

    public static function forbidden(string $message = 'Accès refusé.'): void {
        self::error($message, 403);
    }

    public static function notFound(string $message = 'Ressource non trouvée.'): void {
        self::error($message, 404);
    }

    public static function serverError(string $message = 'Erreur interne du serveur.'): void {
        self::error($message, 500);
    }
}
