<?php
require_once __DIR__ . '/../Database.php';

class SiteFournisseurModel {
    private PDO $db;
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function link(int $id_site, int $id_fournisseur): bool {
        $stmt = $this->db->prepare("INSERT IGNORE INTO site_fournisseur_assoc (id_site, id_fournisseur) VALUES (?, ?)");
        return $stmt->execute([$id_site, $id_fournisseur]);
    }

    public function unlink(int $id_site, int $id_fournisseur): bool {
        $stmt = $this->db->prepare("DELETE FROM site_fournisseur_assoc WHERE id_site=? AND id_fournisseur=?");
        return $stmt->execute([$id_site, $id_fournisseur]);
    }

    public function getFournisseursBySite(int $id_site): array {
        $stmt = $this->db->prepare("SELECT f.* 
                                    FROM fournisseurs f
                                    INNER JOIN site_fournisseur_assoc sfa ON f.id_fournisseur = sfa.id_fournisseur
                                    WHERE sfa.id_site=?");
        $stmt->execute([$id_site]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getSitesByFournisseur(int $id_fournisseur): array {
        $stmt = $this->db->prepare("SELECT s.* 
                                    FROM sites s
                                    INNER JOIN site_fournisseur_assoc sfa ON s.id_site = sfa.id_site
                                    WHERE sfa.id_fournisseur=?");
        $stmt->execute([$id_fournisseur]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // ✅ Nouvelle méthode : toutes les associations
    public function getAll(): array {
        $sql = "SELECT sfa.id_site, s.nom_site, sfa.id_fournisseur, f.nom_fournisseur
                FROM site_fournisseur_assoc sfa
                INNER JOIN sites s ON sfa.id_site = s.id_site
                INNER JOIN fournisseurs f ON sfa.id_fournisseur = f.id_fournisseur
                ORDER BY s.nom_site, f.nom_fournisseur";
        return $this->db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }
}
