<?php
require_once __DIR__ . '/../Database.php';

class RemboursementModel {
    private PDO $db;
    public function __construct() { $this->db = Database::getInstance()->getConnection(); }

    public function getAll($id_avance = null): array {
        $sql = "SELECT r.*, a.id_equipe, e.nom_equipe, u.nom_complet AS operateur, c.nom_caisse
                FROM remboursements r
                LEFT JOIN avances a ON r.id_avance = a.id_avance
                LEFT JOIN equipes e ON a.id_equipe = e.id_equipe
                LEFT JOIN utilisateurs u ON r.id_user_op = u.id_user
                LEFT JOIN caisses c ON r.id_caisse_destination = c.id_caisse
                WHERE 1=1";
        $params = [];
        if (!empty($id_avance)) { $sql .= " AND r.id_avance=?"; $params[] = $id_avance; }
        $sql .= " ORDER BY r.date_remboursement DESC, r.id_remboursement DESC";
        $stmt = $this->db->prepare($sql); $stmt->execute($params);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create(array $data): bool {
        try {
            $this->db->beginTransaction();

            $stmt = $this->db->prepare("SELECT * FROM avances WHERE id_avance=? FOR UPDATE");
            $stmt->execute([$data['id_avance']]);
            $av = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!$av) { $this->db->rollBack(); return false; }

            $montant = (float)$data['montant'];
            if ($montant > (float)$av['montant_restant']) { $this->db->rollBack(); return false; }

            $date = !empty($data['date_remboursement']) ? $data['date_remboursement'] : date('Y-m-d H:i:s');

            $stmt = $this->db->prepare("INSERT INTO remboursements
                (date_remboursement, montant, id_caisse_destination, id_user_op, type_remboursement, id_avance, id_pesage)
                VALUES (?, ?, ?, ?, ?, ?, ?)");
            $ok = $stmt->execute([
                $date, $montant, $data['id_caisse_destination'], $data['id_user_op'],
                $data['type_remboursement'], $data['id_avance'], $data['id_pesage']
            ]);
            if (!$ok) { $this->db->rollBack(); return false; }

            $restant = (float)$av['montant_restant'] - $montant;
            $newStatut = ($restant <= 0.0) ? 'Remboursée' : (($restant < (float)$av['montant']) ? 'Partiellement remboursée' : 'Non remboursée');
            $stmt = $this->db->prepare("UPDATE avances SET montant_restant=?, statut=? WHERE id_avance=?");
            if (!$stmt->execute([$restant, $newStatut, $data['id_avance']])) { $this->db->rollBack(); return false; }

            $stmt = $this->db->prepare("UPDATE caisses SET solde_actuel = solde_actuel + ? WHERE id_caisse = ?");
            if (!$stmt->execute([$montant, $data['id_caisse_destination']])) { $this->db->rollBack(); return false; }

            $stmt = $this->db->prepare("INSERT INTO transactions_caisse
                (date_transaction, type_transaction, libelle, montant, id_caisse, id_user_op)
                VALUES (?, ?, ?, ?, ?, ?)");
            $libelle = "Remboursement avance #".$data['id_avance']." (".$data['type_remboursement'].")";
            if ($data['id_pesage']) $libelle .= " via pesage #".$data['id_pesage'];
            if (!$stmt->execute([$date, 'Remboursement', $libelle, $montant, $data['id_caisse_destination'], $data['id_user_op']])) {
                $this->db->rollBack(); return false;
            }

            $this->db->commit(); return true;
        } catch (Throwable $e) {
            $this->db->rollBack(); return false;
        }
    }
}
