<?php
require_once __DIR__ . '/../Database.php';

class FournisseurModel {
    private PDO $db;
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll(): array {
        $stmt = $this->db->query("SELECT * FROM fournisseurs ORDER BY nom_fournisseur ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getOne(int $id): ?array {
        $stmt = $this->db->prepare("SELECT * FROM fournisseurs WHERE id_fournisseur=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function create(array $data): bool {
        $stmt = $this->db->prepare("INSERT INTO fournisseurs (nom_fournisseur) VALUES (?)");
        return $stmt->execute([$data['nom_fournisseur']]);
    }

    public function update(int $id, array $data): bool {
        $stmt = $this->db->prepare("UPDATE fournisseurs SET nom_fournisseur=? WHERE id_fournisseur=?");
        return $stmt->execute([$data['nom_fournisseur'], $id]);
    }

    public function delete(int $id): bool {
        $stmt = $this->db->prepare("DELETE FROM fournisseurs WHERE id_fournisseur=?");
        return $stmt->execute([$id]);
    }
}
