<?php
require_once __DIR__ . '/../Database.php';

class EquipeModel {
    private PDO $db;
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll(): array {
        $sql = "SELECT e.*, f.nom_fournisseur 
                FROM equipes e 
                LEFT JOIN fournisseurs f ON e.id_fournisseur = f.id_fournisseur
                ORDER BY e.nom_equipe ASC";
        return $this->db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getOne(int $id): ?array {
        $stmt = $this->db->prepare("SELECT * FROM equipes WHERE id_equipe=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function create(array $data): bool {
        $stmt = $this->db->prepare("INSERT INTO equipes (nom_equipe, id_fournisseur) VALUES (?, ?)");
        return $stmt->execute([$data['nom_equipe'], $data['id_fournisseur']]);
    }

    public function update(int $id, array $data): bool {
        $stmt = $this->db->prepare("UPDATE equipes SET nom_equipe=?, id_fournisseur=? WHERE id_equipe=?");
        return $stmt->execute([$data['nom_equipe'], $data['id_fournisseur'], $id]);
    }

    public function delete(int $id): bool {
        $stmt = $this->db->prepare("DELETE FROM equipes WHERE id_equipe=?");
        return $stmt->execute([$id]);
    }
}
