<?php
require_once __DIR__ . '/../Database.php';

class CaisseModel {
    private PDO $db;
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll(): array {
        $sql = "SELECT c.id_caisse, c.nom_caisse, c.solde_actuel, c.id_site, s.nom_site
                FROM caisses c
                LEFT JOIN sites s ON c.id_site = s.id_site
                ORDER BY c.id_caisse ASC";
        return $this->db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create(string $nom, float $solde = 0.0, ?int $id_site = null): bool {
        $stmt = $this->db->prepare("INSERT INTO caisses (nom_caisse, solde_actuel, id_site) VALUES (?, ?, ?)");
        return $stmt->execute([$nom, $solde, $id_site]);
    }

    public function update(int $id, array $data): bool {
        $fields=[]; $params=[];
        if (isset($data['nom_caisse']))   { $fields[]="nom_caisse=?";   $params[]=$data['nom_caisse']; }
        if (isset($data['solde_actuel'])) { $fields[]="solde_actuel=?"; $params[]=(float)$data['solde_actuel']; }
        if (array_key_exists('id_site',$data)) { $fields[]="id_site=?"; $params[]=$data['id_site']; }
        if (empty($fields)) return true;
        $params[]=$id;
        $stmt=$this->db->prepare("UPDATE caisses SET ".implode(", ",$fields)." WHERE id_caisse=?");
        return $stmt->execute($params);
    }

    public function delete(int $id): bool {
        $stmt=$this->db->prepare("DELETE FROM caisses WHERE id_caisse=?");
        return $stmt->execute([$id]);
    }

    public function getSoldeForUpdate(int $id_caisse): float {
        $stmt = $this->db->prepare("SELECT solde_actuel FROM caisses WHERE id_caisse=? FOR UPDATE");
        $stmt->execute([$id_caisse]);
        return (float)($stmt->fetchColumn() ?? 0);
    }

    public function debit(int $id_caisse, float $montant): bool {
        $stmt=$this->db->prepare("UPDATE caisses SET solde_actuel = solde_actuel - ? WHERE id_caisse=?");
        return $stmt->execute([$montant, $id_caisse]);
    }

    public function credit(int $id_caisse, float $montant): bool {
        $stmt=$this->db->prepare("UPDATE caisses SET solde_actuel = solde_actuel + ? WHERE id_caisse=?");
        return $stmt->execute([$montant, $id_caisse]);
    }
}
