<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/utils/Response.php';

// ================== CONTROLEURS ==================
require_once __DIR__ . '/controllers/AuthController.php';

// Core métier
require_once __DIR__ . '/controllers/SiteController.php';
require_once __DIR__ . '/controllers/PesageController.php';
require_once __DIR__ . '/controllers/ExpeditionController.php';
require_once __DIR__ . '/controllers/DepotController.php';
require_once __DIR__ . '/controllers/AnalyseController.php';
require_once __DIR__ . '/controllers/FournisseurController.php';
require_once __DIR__ . '/controllers/EquipeController.php';
require_once __DIR__ . '/controllers/SiteFournisseurController.php';

// Caisses & Transactions
require_once __DIR__ . '/controllers/CaisseController.php';
require_once __DIR__ . '/controllers/TransactionsCaisseController.php';          // simple (getAll)
require_once __DIR__ . '/controllers/TransactionsCaisseAdminController.php';    // admin (filtres + export)
require_once __DIR__ . '/controllers/UtilisateursAdminController.php';

// Avances & Remboursements
require_once __DIR__ . '/controllers/AvanceController.php';
require_once __DIR__ . '/controllers/RemboursementController.php';

// Admin dashboard & appro
require_once __DIR__ . '/controllers/StatsController.php';
require_once __DIR__ . '/controllers/ApproAdminController.php';
require_once __DIR__ . '/controllers/ExportController.php';
require_once __DIR__ . '/controllers/AvancesFournisseursController.php';

require_once __DIR__ . '/controllers/CaisseAdminController.php';

require_once __DIR__ . '/controllers/ReceptionsFournisseursController.php';

// Utilisateurs
require_once __DIR__ . '/controllers/UtilisateurController.php';

// ================== MIDDLEWARE ==================
require_once __DIR__ . '/middleware/AuthMiddleware.php';

// ================== ROUTAGE ==================
$method = $_SERVER['REQUEST_METHOD'];
$uri = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$parts = explode('/', $uri);
$api_index = array_search('api', $parts);
$route = implode('/', array_slice($parts, $api_index + 1));
$ctl = new UtilisateursAdminController();
switch (true) {
    // =============== AUTH ===============
    case ($route === 'login' && $method === 'POST'):
        (new AuthController())->login(); break;

    case ($route === 'logout' && $method === 'POST'):
    (new AuthController())->logout();
    break;


    // =============== SITES ===============
    case ($route === 'sites' && $method === 'GET'):
        (new SiteController())->list(); break;
    case ($route === 'sites' && $method === 'POST'):
        (new SiteController())->create(); break;
    case (preg_match('#^sites/(\d+)$#', $route, $m) && $method === 'GET'):
        (new SiteController())->getOne((int)$m[1]); break;
    case (preg_match('#^sites/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new SiteController())->update((int)$m[1]); break;
    case (preg_match('#^sites/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new SiteController())->delete((int)$m[1]); break;

    // =============== PESAGES ===============
    case ($route === 'pesages' && $method === 'GET'):
        (new PesageController())->list(); break;
    case ($route === 'pesages' && $method === 'POST'):
        (new PesageController())->create(); break;
    case (preg_match('#^pesages/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new PesageController())->update((int)$m[1]); break;
    case (preg_match('#^pesages/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new PesageController())->delete((int)$m[1]); break;

    // =============== EXPEDITIONS ===============
    // Liste des expéditions
    case ($route === 'expeditions' && $method === 'GET'):
        (new ExpeditionController())->list();
        break;
    case ($route === 'expeditions' && $method === 'POST'):
        (new ExpeditionController())->create();
        break;
    case (preg_match('#^expeditions/([0-9]+)$#',$route,$m) && $method==='PUT'):
        (new ExpeditionController())->update((int)$m[1]);
        break;
    case (preg_match('#^expeditions/([0-9]+)/reception$#',$route,$m) && $method==='PUT'):
        (new ExpeditionController())->validerArrivee((int)$m[1]);
        break;
    case (preg_match('#^expeditions/([0-9]+)$#',$route,$m) && $method==='DELETE'):
        (new ExpeditionController())->delete((int)$m[1]);
        break;

    // =============== DEPOTS ===============
    case ($route === 'depots' && $method === 'GET'):
        (new DepotController())->list(); break;
    case ($route === 'depots' && $method === 'POST'):
        (new DepotController())->create(); break;
    case (preg_match('#^depots/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new DepotController())->update((int)$m[1]); break;
    case (preg_match('#^depots/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new DepotController())->delete((int)$m[1]); break;
    // ===== DEPOTS: Historique des arrivées + Stock + Export =====
    case ($route === 'depots/arrivees' && $method === 'GET'):
        (new DepotController())->arrivalsHistory(); break;

    case ($route === 'depots/stock' && $method === 'GET'):
        (new DepotController())->stockTotal(); break;

    case ($route === 'depots/arrivees/export' && $method === 'GET'):
        (new DepotController())->exportArrivalsCSV(); break;

    // =============== ANALYSES LABO ===============
    // Analyses Labo
    // Analyses Labo
    case ($route === 'analyses' && $method === 'GET'):
        (new AnalyseController())->list();
        break;

    case ($route === 'analyses' && $method === 'POST'):
        (new AnalyseController())->create();
        break;

    case (preg_match('#^analyses/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new AnalyseController())->update((int)$m[1]);
        break;

    case (preg_match('#^analyses/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new AnalyseController())->delete((int)$m[1]);
        break;

    case ($route === 'analyses/export' && $method === 'GET'):
        (new AnalyseController())->export();
        break;

    case ($route === 'analyses/total' && $method === 'GET'):
        (new AnalyseController())->totalMontant();
        break;

    case ($route === 'analyses/top-teneur' && $method === 'GET'):
        (new AnalyseController())->topTeneur();
        break;



    // =============== FOURNISSEURS ===============
    case ($route === 'fournisseurs' && $method === 'GET'):
        (new FournisseurController())->list(); break;
    case (preg_match('#^fournisseurs/(\d+)$#', $route, $m) && $method === 'GET'):
        (new FournisseurController())->getOne((int)$m[1]); break;
    case ($route === 'fournisseurs' && $method === 'POST'):
        (new FournisseurController())->create(); break;
    case (preg_match('#^fournisseurs/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new FournisseurController())->update((int)$m[1]); break;
    case (preg_match('#^fournisseurs/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new FournisseurController())->delete((int)$m[1]); break;

    // =============== EQUIPES ===============
    case ($route === 'equipes' && $method === 'GET'):
        (new EquipeController())->list(); break;
    case (preg_match('#^equipes/(\d+)$#', $route, $m) && $method === 'GET'):
        (new EquipeController())->getOne((int)$m[1]); break;
    case ($route === 'equipes' && $method === 'POST'):
        (new EquipeController())->create(); break;
    case (preg_match('#^equipes/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new EquipeController())->update((int)$m[1]); break;
    case (preg_match('#^equipes/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new EquipeController())->delete((int)$m[1]); break;

    // =============== SITE-FOURNISSEUR ===============
    case ($route === 'site-fournisseur' && $method === 'POST'):
        (new SiteFournisseurController())->link(); break;
    case ($route === 'site-fournisseur' && $method === 'DELETE'):
        (new SiteFournisseurController())->unlink(); break;
    case (preg_match('#^sites/(\d+)/fournisseurs$#', $route, $m) && $method === 'GET'):
        (new SiteFournisseurController())->getFournisseursBySite((int)$m[1]); break;
    case (preg_match('#^fournisseurs/(\d+)/sites$#', $route, $m) && $method === 'GET'):
        (new SiteFournisseurController())->getSitesByFournisseur((int)$m[1]); break;
    case ($route === 'site-fournisseur' && $method === 'GET'):
        (new SiteFournisseurController())->listAll(); break;

        // =============== AVANCES ===============
    case ($route === 'avances' && $method === 'GET'):
        (new AvanceController())->list(); break;
    case (preg_match('#^avances/(\d+)$#', $route, $m) && $method === 'GET'):
        (new AvanceController())->getOne((int)$m[1]); break;
    case ($route === 'avances' && $method === 'POST'):
        (new AvanceController())->create(); break;
    case (preg_match('#^avances/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new AvanceController())->update((int)$m[1]); break;
    case (preg_match('#^avances/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new AvanceController())->delete((int)$m[1]); break;
    case (preg_match('#^avances/(\d+)/remboursements$#', $route, $m) && $method === 'GET'):
        (new AvanceController())->listRemboursements((int)$m[1]); break;

    // =============== REMBOURSEMENTS ===============
    case ($route === 'remboursements' && $method === 'GET'):
        (new RemboursementController())->list(); break;
    case ($route === 'remboursements' && $method === 'POST'):
        (new RemboursementController())->create(); break;

    // =============== CAISSES ===============
    case ($route === 'caisse' && $method === 'GET'):
        (new CaisseController())->list(); break;
    case ($route === 'caisse' && $method === 'POST'):
        (new CaisseController())->create(); break;
    case (preg_match('#^caisse/(\d+)$#', $route, $m) && $method === 'PUT'):
        (new CaisseController())->update((int)$m[1]); break;
    case (preg_match('#^caisse/(\d+)$#', $route, $m) && $method === 'DELETE'):
        (new CaisseController())->delete((int)$m[1]); break;

    // =============== MOUVEMENTS CAISSE ===============
    case ($route === 'caisse/sortie' && $method === 'POST'):
        (new CaisseController())->sortie(); break;
    case ($route === 'caisse/demande' && $method === 'POST'):
        (new CaisseController())->demandeAppro(); break;
    case ($route === 'caisse/appro' && $method === 'POST'):
        (new CaisseController())->approValide(); break;

    // =============== TRANSACTIONS CAISSE (simple) ===============
    case ($route === 'transactions_caisse' && $method === 'GET'):
        (new TransactionsCaisseController())->list(); break;

    // =============== UTILISATEURS ===============
    case ($route === 'utilisateurs' && $method === 'GET'):
        (new UtilisateurController())->list(); break;

    // =============== STATS DASHBOARD ===============
    case ($route === 'stats/dashboard' && $method === 'GET'):
        (new StatsController())->dashboard();
        break;

    // NOUVELLE ROUTE POUR LE RÉSUMÉ DES TRANSACTIONS
    case ($route === 'stats/transactions/summary' && $method === 'GET'):
        (new StatsController())->getTransactionSummary();
        break;

    case ($route === 'stats/stocks/sites' && $method === 'GET'):
        (new StatsController())->stocksSites();
        break;

    case ($route === 'stats/stocks/depots' && $method === 'GET'):
        (new StatsController())->stocksDepots();
        break;

    case ($route === 'stats/expeditions/ecarts' && $method === 'GET'):
        (new StatsController())->expeditionsEcarts();
        break;

    case ($route === 'stats/historique/depots' && $method === 'GET'):
        (new StatsController())->historiqueDepots();
        break;

    // Exports CSV
    case ($route === 'export/stocks/depots/historique' && $method === 'GET'):
        (new StatsController())->exportHistoriqueDepots();
        break;

    // =============== ADMIN APPRO ===============
    // *** NOUVELLE ROUTE AJOUTÉE ICI ***
    case ($route === 'admin/caisses/source' && $method === 'GET'):
        (new ApproAdminController())->getSourceCaisses(); break;
    case ($route === 'admin/appro/pending' && $method === 'GET'):
        (new ApproAdminController())->pending(); break;
    case ($route === 'admin/appro/send' && $method === 'POST'):
        (new ApproAdminController())->send(); break;

    // =============== ADMIN TRANSACTIONS (filtrées + export CSV) ===============
    case ($route === 'admin/transactions' && $method === 'GET'):
        (new TransactionsCaisseAdminController())->list(); break;
    case ($route === 'admin/transactions/export' && $method === 'GET'):
        (new TransactionsCaisseAdminController())->export(); break;

    // =============== EXPORT CSV généraux ===============
    case ($route === 'export/transactions' && $method === 'GET'):
        (new ExportController())->transactions(); break;
    case ($route === 'export/avances' && $method === 'GET'):
        (new ExportController())->avances(); break;
    case ($route === 'export/remboursements' && $method === 'GET'):
        (new ExportController())->remboursements(); break;
    case ($route === 'export/expeditions/transit' && $method === 'GET'):
        (new ExportController())->expeditionsTransit(); break;
    case ($route === 'export/stocks/sites' && $method === 'GET'):
        (new ExportController())->stocksSites(); break;
    case ($route === 'export/stocks/depots' && $method === 'GET'):
        (new ExportController())->stocksDepots(); break;
    case ($route === 'export/expeditions/ecarts' && $method === 'GET'):
        (new ExportController())->expeditionsEcarts(); break;
    // =============== ADMIN CAISSES ===============
    // =============== ADMIN CAISSES ===============
    // Liste des caisses admin
    case ($route === 'admin/caisses/admin' && $method === 'GET'):
        (new CaisseAdminController())->listCaissesAdmin(); break;

    // Liste des caisses sites
    case ($route === 'admin/caisses/sites' && $method === 'GET'):
        (new CaisseAdminController())->listCaissesSites(); break;

    // Entrée (ajout montant dans caisse admin)
    case ($route === 'admin/caisses/admin/add' && $method === 'POST'):
        (new CaisseAdminController())->entreeAdmin(); break;

    // Sortie divers (débit caisse admin)
    case ($route === 'admin/caisses/admin/sortie' && $method === 'POST'):
        (new CaisseAdminController())->sortieDivers(); break;

    // Historique des approvisionnements Admin → Sites
    case ($route === 'admin/appro/historique' && $method === 'GET'):
        (new CaisseAdminController())->historiqueAppro(); break;

    // Historique des transactions caisses sites
    case ($route === 'admin/transactions/sites' && $method === 'GET'):
        (new CaisseAdminController())->historiqueTransactionsSites(); break;

    // Export CSV appro Admin → Sites
    case ($route === 'admin/appro/export' && $method === 'GET'):
        (new CaisseAdminController())->exportApproCSV(); break;

    // Export CSV transactions caisses sites
    case ($route === 'admin/transactions/sites/export' && $method === 'GET'):
        (new CaisseAdminController())->exportTransactionsSitesCSV(); break;

    // Export CSV opérations caisse Admin
    case ($route === 'admin/caisses/admin/export' && $method === 'GET'):
        (new CaisseAdminController())->exportAdminOpsCSV(); break;
    // Caisse Admin

        // Réceptions fournisseurs
    case ($route === 'receptions_fournisseurs' && $method === 'POST'):
        (new ReceptionsFournisseursController())->create();
        break;

    case ($route === 'receptions_fournisseurs' && $method === 'GET'):
        (new ReceptionsFournisseursController())->list();
        break;

    case ($route === 'receptions_fournisseurs/export' && $method === 'GET'):
        (new ReceptionsFournisseursController())->export();
        break;

    // Stock dépôt (flux fournisseurs)
    case ($route === 'depots/stock_fournisseurs' && $method === 'GET'):
        (new ReceptionsFournisseursController())->stockDepot();
        break;
    
     case ($route === 'admin/utilisateurs' && $method === 'POST'):
        $ctl->create(); break;

    case ($route === 'admin/utilisateurs/export' && $method === 'GET'):
        $ctl->exportUsers(); break;

    case ($route === 'admin/users/connected' && $method === 'GET'):
        $ctl->connected(); break;

    case ($route === 'admin/users/connected/export' && $method === 'GET'):
        $ctl->exportConnected(); break;

    case ($route === 'admin/audit/logins' && $method === 'GET'):
        $ctl->logins(); break;

    case ($route === 'admin/audit/logins/export' && $method === 'GET'):
        $ctl->exportLogins(); break;

    case ($route === 'admin/audit/actions' && $method === 'GET'):
        $ctl->auditActions(); break;

    case ($route === 'admin/audit/actions/export' && $method === 'GET'):
        $ctl->exportAudit(); break;

    // ================== AVANCES FOURNISSEURS ==================

    // Liste des avances (GET /admin/avances/fournisseurs)
    case ($route === 'admin/avances/fournisseurs' && $method === 'GET'):
        (new AvancesFournisseursController())->list();
        break;

    // Création d'une avance (POST /admin/avances/fournisseurs)
    case ($route === 'admin/avances/fournisseurs' && $method === 'POST'):
        (new AvancesFournisseursController())->create();
        break;

    // Rembourser une avance (POST /admin/avances/fournisseurs/{id}/rembourser)
    case (preg_match('#^admin/avances/fournisseurs/(\d+)/rembourser$#', $route, $m) && $method === 'POST'):
        (new AvancesFournisseursController())->reimburse((int)$m[1]);
        break;

    // Historique des remboursements (GET /admin/avances/fournisseurs/{id}/historique)
    case (preg_match('#^admin/avances/fournisseurs/(\d+)/historique$#', $route, $m) && $method === 'GET'):
        (new AvancesFournisseursController())->getHistory((int)$m[1]);
        break;


    // =============== 404 ===============
    default:
        Response::notFound('Route API non trouvée.'); break;
}