<?php
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../Database.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class UtilisateurController {
    public function list(): void {
        AuthMiddleware::ensureAuthorized();
        $db = Database::getInstance()->getConnection();

        $stmt = $db->query("SELECT id_user, nom_complet, login FROM utilisateurs ORDER BY nom_complet IS NULL, nom_complet ASC, login ASC");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        Response::success(['items' => $rows], 'Liste des utilisateurs');
    }
}
