<?php
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';
require_once __DIR__ . '/../models/TransactionsCaisseModel.php';

class TransactionsCaisseController {
    private TransactionsCaisseModel $tx;
    public function __construct() { $this->tx = new TransactionsCaisseModel(); }

    public function list(): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->tx->getAll();
        Response::success(['items' => $rows], "Historique transactions caisse");
    }
}
