<?php
require_once __DIR__ . '/../models/SiteFournisseurModel.php';
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class SiteFournisseurController {
    private SiteFournisseurModel $model;

    public function __construct() {
        $this->model = new SiteFournisseurModel();
    }

    public function link(): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['id_site']) || empty($input['id_fournisseur'])) {
            Response::error("Champs obligatoires manquants (id_site, id_fournisseur)", 400);
        }
        $ok = $this->model->link($input['id_site'], $input['id_fournisseur']);
        $ok ? Response::success([], "Association créée") : Response::serverError("Erreur association");
    }

    public function unlink(): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['id_site']) || empty($input['id_fournisseur'])) {
            Response::error("Champs obligatoires manquants (id_site, id_fournisseur)", 400);
        }
        $ok = $this->model->unlink($input['id_site'], $input['id_fournisseur']);
        $ok ? Response::success([], "Association supprimée") : Response::serverError("Erreur suppression association");
    }

    // ✅ Corrigé : renvoie toujours data.items
    public function getFournisseursBySite(int $id_site): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->model->getFournisseursBySite($id_site);
        Response::success(['items' => $rows], "Fournisseurs du site");
    }

    // ✅ Corrigé : renvoie toujours data.items
    public function getSitesByFournisseur(int $id_fournisseur): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->model->getSitesByFournisseur($id_fournisseur);
        Response::success(['items' => $rows], "Sites du fournisseur");
    }

    // ✅ Corrigé : renvoie toujours data.items
    public function listAll(): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->model->getAll();
        Response::success(['items' => $rows], "Toutes les associations site ↔ fournisseur");
    }
}
