<?php
require_once __DIR__ . '/../models/RemboursementModel.php';
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class RemboursementController {
    private RemboursementModel $model;
    public function __construct() { $this->model = new RemboursementModel(); }

    public function list(): void {
        AuthMiddleware::ensureAuthorized();
        $id_avance = $_GET['avance'] ?? null;
        $rows = $this->model->getAll($id_avance);
        Response::success(['items' => $rows], "Liste des remboursements");
    }

    public function create(): void {
        AuthMiddleware::ensureAuthorized();
        $in = json_decode(file_get_contents('php://input'), true) ?? [];

        $required = ['id_avance','montant','id_caisse_destination','type_remboursement'];
        foreach ($required as $k) if (empty($in[$k])) Response::error("Champ obligatoire manquant: $k", 400);
        if (!is_numeric($in['montant']) || $in['montant'] <= 0) Response::error("Montant invalide", 400);
        if (!in_array($in['type_remboursement'], ['Espèce','Déduction Pesage'])) Response::error("Type remboursement invalide", 400);
        if ($in['type_remboursement'] === 'Déduction Pesage' && empty($in['id_pesage'])) Response::error("id_pesage requis pour déduction", 400);

        $userId = AuthMiddleware::getUserId();

        $ok = $this->model->create([
            'id_avance' => (int)$in['id_avance'],
            'montant' => (float)$in['montant'],
            'id_caisse_destination' => (int)$in['id_caisse_destination'],
            'id_user_op' => (int)$userId,
            'type_remboursement' => $in['type_remboursement'],
            'id_pesage' => $in['id_pesage'] ?? null,
            'date_remboursement' => $in['date_remboursement'] ?? null
        ]);
        $ok ? Response::success([], "Remboursement enregistré") : Response::serverError("Erreur enregistrement remboursement");
    }
}
