<?php
require_once __DIR__ . '/../models/ReceptionsFournisseursModel.php';
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class ReceptionsFournisseursController {
    private ReceptionsFournisseursModel $model;

    public function __construct() {
        $this->model = new ReceptionsFournisseursModel();
    }

    // POST /receptions_fournisseurs
    public function create(): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        
        // AJOUT : Vérification du nouveau champ id_site_provenance
        if (empty($input['id_fournisseur']) || empty($input['id_site_provenance']) || empty($input['id_depot']) || empty($input['quantite_T']) || empty($input['commentaire'])) {
            Response::error("Champs requis: id_fournisseur, id_site_provenance, id_depot, quantite_T, commentaire", 400);
        }

        $date = $input['date_reception'] ?? date('Y-m-d H:i:s');
        $data = [
            'date_reception'     => $date,
            'id_fournisseur'     => (int)$input['id_fournisseur'],
            'id_site_provenance' => (int)$input['id_site_provenance'], // AJOUT
            'id_depot'           => (int)$input['id_depot'],
            'quantite_T'         => (float)$input['quantite_T'],
            'commentaire'        => trim($input['commentaire']),
            'id_user'            => AuthMiddleware::getUserId()
        ];

        $ok = $this->model->create($data);
        $ok ? Response::success([], "Réception fournisseur enregistrée") : Response::serverError("Erreur enregistrement");
    }

    // GET /receptions_fournisseurs
    public function list(): void {
        // ... (aucune modification nécessaire ici, mais la méthode dans le modèle sera modifiée)
        AuthMiddleware::ensureAuthorized();
        $page  = (int)($_GET['page'] ?? 1);
        $limit = (int)($_GET['limit'] ?? 50);
        $id_depot = isset($_GET['id_depot']) ? (int)$_GET['id_depot'] : null;
        $id_fournisseur = isset($_GET['id_fournisseur']) ? (int)$_GET['id_fournisseur'] : null;
        $from = $_GET['from'] ?? null;
        $to   = $_GET['to'] ?? null;

        $data = $this->model->list($page, $limit, $id_depot, $id_fournisseur, $from, $to);
        Response::success($data, "Liste des réceptions fournisseurs");
    }

    // GET /receptions_fournisseurs/export
    public function export(): void {
        // ... (aucune modification nécessaire ici, mais la méthode dans le modèle sera modifiée)
        AuthMiddleware::ensureAuthorized();
        $id_depot = isset($_GET['id_depot']) ? (int)$_GET['id_depot'] : null;
        $id_fournisseur = isset($_GET['id_fournisseur']) ? (int)$_GET['id_fournisseur'] : null;
        $from = $_GET['from'] ?? null;
        $to   = $_GET['to'] ?? null;

        $csv = $this->model->exportCsv($id_depot, $id_fournisseur, $from, $to);
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="receptions_fournisseurs.csv"');
        echo $csv;
        exit;
    }

    // GET /depots/stock_fournisseurs
    public function stockDepot(): void {
        AuthMiddleware::ensureAuthorized();
        $id_depot = isset($_GET['id_depot']) ? (int)$_GET['id_depot'] : null;
        $from = $_GET['from'] ?? null;
        $to   = $_GET['to'] ?? null;

        $data = $this->model->getDepotStock($id_depot, $from, $to);
        Response::success($data, "Stock dépôt");
    }
}