<?php
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';
require_once __DIR__ . '/../models/Pesage.php';

class PesageController {
    private $pesage;

    public function __construct() {
        $this->pesage = new Pesage();
    }

    public function list() {
        $payload = AuthMiddleware::checkAuthAndRole([ROLE_SURSITE]);
        $id_user = (int)$payload['id_user'];

        $qp = $_GET ?? [];
        $page  = isset($qp['page']) ? max(1, (int)$qp['page']) : 1;
        $limit = isset($qp['limit']) ? min(50, max(1, (int)$qp['limit'])) : 10;
        $filters = [
            'site' => isset($qp['site']) ? (int)$qp['site'] : null,
            'q' => $qp['q'] ?? null,
            'from' => $qp['from'] ?? null,
            'to' => $qp['to'] ?? null
        ];

        $data = $this->pesage->listByUserSites($id_user, $filters, $page, $limit);
        Response::success($data, 'Liste des pesages');
    }

    public function create() {
        $payload = AuthMiddleware::checkAuthAndRole([ROLE_SURSITE]);
        $id_user = (int)$payload['id_user'];

        $body = json_decode(file_get_contents('php://input'), true);
        if (!$body) Response::error('Payload invalide', 400);

        try {
            $row = $this->pesage->create($body, $id_user);
            Response::success($row, 'Pesage créé', 201);
        } catch (Exception $e) {
            Response::error($e->getMessage(), 400);
        }
    }

    public function update($id_pesage) {
        $payload = AuthMiddleware::checkAuthAndRole([ROLE_SURSITE]);
        $id_user = (int)$payload['id_user'];

        $body = json_decode(file_get_contents('php://input'), true);
        if (!$id_pesage) Response::error('id_pesage requis', 422);

        try {
            $ok = $this->pesage->update((int)$id_pesage, $body, $id_user);
            if ($ok) Response::success([], 'Pesage mis à jour');
            else Response::error('Aucune modification', 400);
        } catch (Exception $e) {
            Response::error($e->getMessage(), 400);
        }
    }

    public function delete($id_pesage) {
        $payload = AuthMiddleware::checkAuthAndRole([ROLE_SURSITE]);
        $id_user = (int)$payload['id_user'];

        if (!$id_pesage) Response::error('id_pesage requis', 422);

        try {
            $ok = $this->pesage->delete((int)$id_pesage, $id_user);
            if ($ok) Response::success([], 'Pesage supprimé');
            else Response::error('Suppression non effectuée', 400);
        } catch (Exception $e) {
            Response::error($e->getMessage(), 400);
        }
    }
}
