<?php
require_once __DIR__ . '/../models/FournisseurModel.php';
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class FournisseurController {
    private FournisseurModel $model;

    public function __construct() {
        $this->model = new FournisseurModel();
    }

    // Liste tous les fournisseurs
    public function list(): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->model->getAll();
        Response::success(['items' => $rows], "Liste des fournisseurs");
    }

    public function getOne(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $data = $this->model->getOne($id);
        $data ? Response::success($data) : Response::notFound("Fournisseur introuvable");
    }

    public function create(): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['nom_fournisseur'])) Response::error("Nom fournisseur obligatoire", 400);
        $ok = $this->model->create($input);
        $ok ? Response::success([], "Fournisseur créé") : Response::serverError("Erreur création fournisseur");
    }

    public function update(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['nom_fournisseur'])) Response::error("Nom fournisseur obligatoire", 400);
        $ok = $this->model->update($id, $input);
        $ok ? Response::success([], "Fournisseur mis à jour") : Response::serverError("Erreur mise à jour fournisseur");
    }

    public function delete(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $ok = $this->model->delete($id);
        $ok ? Response::success([], "Fournisseur supprimé") : Response::serverError("Erreur suppression fournisseur");
    }
}
