<?php
/**
 * Gère les exportations CSV pour diverses entités du système.
 */
class ExportController {
    
    private $pdo;

    public function __construct() {
        // AuthMiddleware::check(ROLE_ADMIN);
        $this->pdo = Database::getInstance()->getConnection();
    }
    
    public function expeditionsTransit() {
        $stmt = $this->pdo->query("
            SELECT e.id_expedition as `ID`, DATE_FORMAT(e.date_depart, '%Y-%m-%d %H:%i') as `Date Départ`, e.immatriculation as `Immatriculation`, e.nom_chauffeur as `Chauffeur`, e.poids_depart_T as `Poids Départ (T)`, s.nom_site AS `Site Origine`, d.nom_depot AS `Dépôt Destination` 
            FROM expeditions e 
            LEFT JOIN sites s ON e.id_site_origine = s.id_site 
            LEFT JOIN depots d ON e.id_depot_destination = d.id_depot 
            WHERE e.statut = 'En transit' ORDER BY e.date_depart DESC
        ");
        $this->outputCsv('Export_Expeditions_En_Transit.csv', $stmt->fetchAll(PDO::FETCH_ASSOC));
    }

    public function stocksSites() {
        $stmt = $this->pdo->query("
            SELECT s.nom_site as `Site`, s.stock_actuel as `Stock Actuel (T)`, (SELECT DATE_FORMAT(MAX(date_mouvement), '%Y-%m-%d %H:%i') FROM historique_stock WHERE entite_type = 'site' AND id_entite = s.id_site) as `Dernier Mouvement`
            FROM sites s ORDER BY s.nom_site ASC
        ");
        $this->outputCsv('Export_Stocks_Sur_Sites.csv', $stmt->fetchAll(PDO::FETCH_ASSOC));
    }

    public function stocksDepots() {
        $stmt = $this->pdo->query("
            SELECT d.nom_depot as `Dépôt`, COALESCE(SUM(e.poids_arrivee_T), 0) as `Poids Arrivé Total (T)`, DATE_FORMAT(MAX(e.date_arrivee), '%Y-%m-%d %H:%i') as `Dernière Arrivée`
            FROM depots d
            LEFT JOIN expeditions e ON d.id_depot = e.id_depot_destination AND e.statut = 'Arrivé'
            GROUP BY d.id_depot, d.nom_depot ORDER BY d.nom_depot ASC
        ");
        $this->outputCsv('Export_Stocks_Sur_Dépôts.csv', $stmt->fetchAll(PDO::FETCH_ASSOC));
    }

    public function expeditionsEcarts() {
        $stmt = $this->pdo->query("
            SELECT e.id_expedition as `ID Expédition`, s.nom_site AS `Site Origine`, e.poids_depart_T as `Poids Départ (T)`, e.poids_arrivee_T as `Poids Arrivée (T)`, e.ecart_poids_T as `Écart (T)`, DATE_FORMAT(e.date_arrivee, '%Y-%m-%d %H:%i') as `Date Arrivée`
            FROM expeditions e LEFT JOIN sites s ON e.id_site_origine = s.id_site
            WHERE e.statut = 'Arrivé' AND e.ecart_poids_T IS NOT NULL AND e.ecart_poids_T != 0
            ORDER BY e.date_arrivee DESC
        ");
        $this->outputCsv('Export_Ecarts_Expeditions.csv', $stmt->fetchAll(PDO::FETCH_ASSOC));
    }
    
    /**
     * Utilitaire pour générer et envoyer un fichier CSV.
     */
    private function outputCsv(string $filename, array $data) {
        if (empty($data)) {
            // Créer un fichier vide avec seulement les entêtes si aucune donnée
            header('Content-Type: text/plain; charset=utf-8');
            echo "Aucune donnée à exporter pour ce rapport.";
            exit;
        }
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');

        $output = fopen('php://output', 'w');
        
        // AJOUT: BOM pour compatibilité Excel avec les caractères UTF-8
        echo "\xEF\xBB\xBF";
        
        fputcsv($output, array_keys($data[0]), ';');
        foreach ($data as $row) {
            fputcsv($output, $row, ';');
        }
        fclose($output);
        exit;
    }
}