<?php
require_once __DIR__ . '/../models/EquipeModel.php';
require_once __DIR__ . '/../utils/Response.php';
require_once __DIR__ . '/../middleware/AuthMiddleware.php';

class EquipeController {
    private EquipeModel $model;

    public function __construct() {
        $this->model = new EquipeModel();
    }

    // ✅ Corrigé : renvoie data.items
    public function list(): void {
        AuthMiddleware::ensureAuthorized();
        $rows = $this->model->getAll();
        Response::success(['items' => $rows], "Liste des équipes");
    }

    public function getOne(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $data = $this->model->getOne($id);
        $data ? Response::success($data) : Response::notFound("Équipe introuvable");
    }

    public function create(): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['nom_equipe']) || empty($input['id_fournisseur'])) {
            Response::error("Champs obligatoires manquants (nom_equipe, id_fournisseur)", 400);
        }
        $ok = $this->model->create($input);
        $ok ? Response::success([], "Équipe créée") : Response::serverError("Erreur création équipe");
    }

    public function update(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        if (empty($input['nom_equipe']) || empty($input['id_fournisseur'])) {
            Response::error("Champs obligatoires manquants (nom_equipe, id_fournisseur)", 400);
        }
        $ok = $this->model->update($id, $input);
        $ok ? Response::success([], "Équipe mise à jour") : Response::serverError("Erreur mise à jour équipe");
    }

    public function delete(int $id): void {
        AuthMiddleware::ensureAuthorized();
        $ok = $this->model->delete($id);
        $ok ? Response::success([], "Équipe supprimée") : Response::serverError("Erreur suppression équipe");
    }
}
