<?php
/**
 * Fichier de configuration global de l'API (Constantes).
 * Ce fichier doit être inclus au début de chaque script.
 */

// ----------------------
// 1. CONFIGURATION DE LA BASE DE DONNÉES (MySQL)
// ----------------------
define('DB_HOST', 'localhost');
define('DB_NAME', 'translog_oyjt_db'); 
define('DB_USER', 'translog_oyjt_user');
define('DB_PASS', '@Amaterasu19'); 
define('DB_CHARSET', 'utf8mb4');

// ----------------------
// 2. CONFIGURATION DE SÉCURITÉ DE L'API
// ----------------------

// Clé secrète pour les JWT et le hachage des mots de passe.
// !! IMPORTANT !! : Changez cette clé pour une chaîne longue, aléatoire et unique en production.
define('SECRET_KEY', 'UneCleSecreteTresLongueEtComplexePourLeHachageDesMotsDePasse!');

// Durée de validité du jeton JWT en secondes (ici, 24 heures)
define('JWT_EXPIRATION', 86400); // 60 * 60 * 24

// ----------------------
// 3. EN-TÊTES HTTP (CORS)
// ----------------------
// Autoriser les requêtes depuis n'importe quel domaine. Pour la production,
// il est recommandé de remplacer '*' par le domaine de votre application cliente.
// Exemple : header("Access-Control-Allow-Origin: http://mon-app.com");
header("Access-Control-Allow-Origin: *"); 
header("Content-Type: application/json; charset=" . DB_CHARSET);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Gestion des requêtes OPTIONS (preflight) pour CORS
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// ----------------------
// 4. GESTION DES ERREURS
// ----------------------
// Activer l'affichage des erreurs pour le développement.
// !! IMPORTANT !! : Mettre à 0 en production pour des raisons de sécurité.
ini_set('display_errors', 1);
error_reporting(E_ALL);

// ----------------------
// 5. CONSTANTES DE RÔLES
// ----------------------
define('ROLE_ADMIN', 'admin');
define('ROLE_SURSITE', 'sursite');
define('ROLE_SURDEPOT', 'surdepot');