<?php
require_once 'config.php';
require_once '../vendor/autoload.php'; // si tu utilises Dompdf

use Dompdf\Dompdf;

$pdo = getDbConnection();
$id_facture = (int)($_GET['id_facture'] ?? 0);

$stmt = $pdo->prepare("
    SELECT f.*, c.nom_client, v.immatriculation,
           (COALESCE(p.kilometrage_fin_mois,0) - COALESCE(p.kilometrage_debut_mois,0)) AS kilometrage_total
    FROM facturations f
    JOIN clients c ON f.id_client = c.id_client
    JOIN pointage_vehicule p ON f.id_pointage = p.id_pointage
    JOIN vehicules v ON p.id_vehicule = v.id_vehicule
    WHERE f.id_facture = ?
");
$stmt->execute([$id_facture]);
$facture = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$facture) {
    die("Facture introuvable");
}

$html = "
<h1>Facture #{$facture['id_facture']}</h1>
<p><strong>Date :</strong> {$facture['date_facture']}</p>
<p><strong>Client :</strong> {$facture['nom_client']}</p>
<p><strong>Véhicule :</strong> {$facture['immatriculation']}</p>
<p><strong>Kilométrage :</strong> {$facture['kilometrage_total']} Km</p>
<p><strong>Tarif au Km :</strong> {$facture['tarif_km']} Ar</p>
<p><strong>Montant HT :</strong> {$facture['montant_ht']} Ar</p>
<p><strong>TVA :</strong> {$facture['montant_tva']} Ar</p>
<p><strong>Montant TTC :</strong> {$facture['montant_ttc']} Ar</p>
";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("facture_{$facture['id_facture']}.pdf", ["Attachment" => false]);
