<?php
// php/config.php

// Définir le mode de développement/production
// En mode développement, les erreurs PDO détaillées seront affichées.
// En mode production, un message générique sera affiché et l'erreur sera loggée.
define('ENVIRONMENT', 'development'); // Changez à 'production' en déploiement réel

define('DB_HOST', 'localhost'); // Généralement 'localhost'
define('DB_NAME', 'aseshopm_pl'); // Nom de votre base de données
define('DB_USER', 'root');     // Votre nom d'utilisateur MySQL
define('DB_PASS', '');         // Votre mot de passe MySQL

// Configuration du logging des erreurs PHP
ini_set('log_errors', 'On');
ini_set('error_log', __DIR__ . '/../logs/php_errors.log'); // Chemin vers votre fichier de log. Assurez-vous que le dossier 'logs' existe et est accessible en écriture.
error_reporting(E_ALL); // Rapporter toutes les erreurs


// Fonction de connexion à la base de données
function getDbConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Active les exceptions pour les erreurs PDO
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Récupère les résultats sous forme de tableau associatif par défaut
                PDO::ATTR_EMULATE_PREPARES   => false
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        // Enregistrement détaillé de l'erreur pour le débogage
        error_log("DB Connection Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());

        // Afficher un message d'erreur approprié à l'environnement
        if (ENVIRONMENT === 'development') {
            die("Erreur de connexion à la base de données : " . $e->getMessage() . " (Code: " . $e->getCode() . ")");
        } else {
            die("Une erreur interne est survenue. Veuillez réessayer plus tard.");
        }
    }
}