<?php
// php/authentification.php

session_start();

require_once 'config.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['username']) && isset($_POST['password'])) {
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);

        if (empty($username) || empty($password)) {
            $response['message'] = 'Veuillez saisir votre nom d\'utilisateur et votre mot de passe.';
            echo json_encode($response);
            exit();
        }

        try {
            $pdo = getDbConnection();

            // Correction ici : Utilisation de marqueurs de paramètres distincts pour éviter l'erreur HY093
            $stmt = $pdo->prepare("
                SELECT u.id_utilisateur, u.nom_utilisateur, u.mot_de_passe_hash, r.nom_role
                FROM utilisateurs u
                JOIN roles r ON u.id_role = r.id_role
                WHERE u.nom_utilisateur = :username_name OR u.email = :username_email
            ");
            // Passage explicite de la même valeur pour les deux marqueurs distincts
            $stmt->execute([
                ':username_name' => $username,
                ':username_email' => $username
            ]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user && password_verify($password, $user['mot_de_passe_hash'])) {
                $_SESSION['loggedin'] = true;
                $_SESSION['user_id'] = $user['id_utilisateur'];
                $_SESSION['username'] = $user['nom_utilisateur'];
                $_SESSION['role'] = $user['nom_role'];

                $updateStmt = $pdo->prepare("UPDATE utilisateurs SET derniere_connexion = NOW() WHERE id_utilisateur = :id");
                $updateStmt->execute([':id' => $user['id_utilisateur']]);

                $response['success'] = true;
                $response['message'] = 'Connexion réussie. Redirection...'; // Message de succès avant redirection
                $response['role'] = $user['nom_role'];

            } else {
                // Ici, nous pouvons affiner pour le débogage seulement, mais en prod, un message générique est mieux.
                if (!$user) {
                    $response['message'] = 'Nom d\'utilisateur inconnu. Veuillez vérifier votre nom d\'utilisateur.';
                    error_log("Login failed (username not found) for username: " . $username . " from IP: " . $_SERVER['REMOTE_ADDR']);
                } else {
                    $response['message'] = 'Mot de passe incorrect. Veuillez réessayer.';
                    error_log("Login failed (incorrect password) for username: " . $username . " from IP: " . $_SERVER['REMOTE_ADDR']);
                }
            }

        } catch (PDOException $e) {
            error_log("Authentication PDO Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
            if (ENVIRONMENT === 'development') {
                $response['message'] = "Erreur de base de données: " . $e->getMessage();
            } else {
                $response['message'] = 'Une erreur interne est survenue lors de la tentative de connexion. Veuillez réessayer.';
            }
        } catch (Exception $e) {
            error_log("Authentication General Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
            if (ENVIRONMENT === 'development') {
                $response['message'] = "Erreur inattendue: " . $e->getMessage();
            } else {
                $response['message'] = 'Une erreur inattendue est survenue. Veuillez contacter l\'administrateur.';
            }
        }

    } else {
        $response['message'] = 'Les champs de nom d\'utilisateur et de mot de passe sont requis.';
    }
} elseif (isset($_GET['action']) && $_GET['action'] === 'logout') {
    // Déconnexion
    if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
        error_log("User " . ($_SESSION['username'] ?? 'unknown') . " logged out.");
    }
    session_unset();
    session_destroy();
    // Redirection HTTP directe pour la déconnexion
    header('Location: ../index');
    exit();
} else {
    // Requête HTTP non POST pour la connexion, ou action non reconnue
    header('Location: ../index'); // Redirige vers la page de connexion
    exit();
}

echo json_encode($response);
exit();
