<?php
// ASE_Maintenance/php/api_magasinier.php

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || !isset($_SESSION['role']) || $_SESSION['role'] !== 'Magasinier') {
    echo json_encode(['success' => false, 'message' => 'Accès non autorisé.']);
    exit();
}

$pdo = getDbConnection();
$input = file_get_contents('php://input');
$data = json_decode($input, true);
$action = $data['action'] ?? '';

switch ($action) {
    case 'getDashboardMagasinierData':
        // MODIFIÉ: Compter la quantité totale de pièces en stock
        $totalStockCount = 0;
        try {
            $stmt = $pdo->query("SELECT SUM(stock_initial) AS total_count FROM piece");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $totalStockCount = $result['total_count'] ?? 0;
        } catch (PDOException $e) {
            error_log("Erreur PDO pour totalStockCount: " . $e->getMessage());
        }

        // MODIFIÉ: Compter le total des pièces entrées (réceptions) sur 30 jours
        $totalEntriesCount = 0;
        try {
            $stmt = $pdo->prepare("SELECT SUM(lr.quantite_receptionnee) AS total_entries_count
                                   FROM lignes_reception lr
                                   JOIN receptions r ON lr.id_reception = r.id_reception
                                   WHERE r.date_reception >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $totalEntriesCount = $result['total_entries_count'] ?? 0;
        } catch (PDOException $e) {
            error_log("Erreur PDO pour totalEntriesCount: " . $e->getMessage());
        }

        // MODIFIÉ: Compter le total des pièces sorties sur 30 jours
        $totalExitsCount = 0;
        try {
            $stmt = $pdo->prepare("SELECT SUM(dsp.quantite_sortie) AS total_exits_count
                                   FROM details_sortie_piece dsp
                                   JOIN sorties_pieces sp ON dsp.id_sortie = sp.id_sortie
                                   WHERE sp.date_sortie >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $totalExitsCount = $result['total_exits_count'] ?? 0;
        } catch (PDOException $e) {
            error_log("Erreur PDO pour totalExitsCount: " . $e->getMessage());
        }

        // Compter les pièces en rupture ou faible stock
        $outOfStockCount = 0;
        try {
            $stmt = $pdo->query("SELECT COUNT(*) FROM piece WHERE stock_initial <= seuil_alerte");
            $outOfStockCount = $stmt->fetchColumn();
        } catch (PDOException $e) {
            error_log("Erreur PDO pour outOfStockCount: " . $e->getMessage());
        }

        echo json_encode([
            'success' => true,
            'totalStockCount' => $totalStockCount,
            'totalEntriesCount' => $totalEntriesCount,
            'totalExitsCount' => $totalExitsCount,
            'outOfStockCount' => $outOfStockCount
        ]);
        break;

    // ... Le reste du fichier (getAllTransactions, getAllPiecesWithStock) reste inchangé ...
    case 'getAllTransactions':
        $transactions = [];
        try {
            $stmt_receptions = $pdo->prepare("SELECT lr.id_piece, p.nom_piece, p.reference, lr.quantite_receptionnee, r.date_reception AS date, 'Réception' AS type FROM lignes_reception lr JOIN receptions r ON lr.id_reception = r.id_reception JOIN piece p ON lr.id_piece = p.id_piece ORDER BY r.date_reception DESC");
            $stmt_receptions->execute();
            while ($row = $stmt_receptions->fetch(PDO::FETCH_ASSOC)) {
                $transactions[] = $row;
            }
            $stmt_sorties = $pdo->prepare("SELECT dsp.id_piece, p.nom_piece, p.reference, dsp.quantite_sortie, sp.date_sortie AS date, 'Sortie' AS type FROM details_sortie_piece dsp JOIN sorties_pieces sp ON dsp.id_sortie = sp.id_sortie JOIN piece p ON dsp.id_piece = p.id_piece ORDER BY sp.date_sortie DESC");
            $stmt_sorties->execute();
            while ($row = $stmt_sorties->fetch(PDO::FETCH_ASSOC)) {
                $transactions[] = $row;
            }
            usort($transactions, function($a, $b) {
                return strtotime($a['date']) - strtotime($b['date']);
            });
            $processed_transactions = [];
            $temp_piece_stocks = [];
            foreach ($transactions as $transaction) {
                $id_piece = (int)$transaction['id_piece'];
                $quantity = (float)($transaction['quantite_receptionnee'] ?? $transaction['quantite_sortie']);
                $type = $transaction['type'];
                if (!isset($temp_piece_stocks[$id_piece])) {
                    $temp_piece_stocks[$id_piece] = 0;
                }
                $stock_avant_op = $temp_piece_stocks[$id_piece];
                if ($type === 'Réception') {
                    $stock_apres_op = $stock_avant_op + $quantity;
                } else {
                    $stock_apres_op = $stock_avant_op - $quantity;
                }
                $transaction['stock_avant_op'] = max(0, $stock_avant_op);
                $transaction['stock_apres_op'] = max(0, $stock_apres_op);
                $temp_piece_stocks[$id_piece] = $stock_apres_op;
                $processed_transactions[] = $transaction;
            }
            $processed_transactions = array_reverse($processed_transactions);
            echo json_encode(['success' => true, 'transactions' => $processed_transactions]);
        } catch (PDOException $e) {
            error_log("Erreur PDO lors de la récupération des transactions: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Erreur de base de données.']);
        }
        break;
    case 'getAllPiecesWithStock':
        try {
            $stmt = $pdo->query("SELECT id_piece, nom_piece, reference, stock_initial, seuil_alerte FROM piece ORDER BY nom_piece ASC");
            $allPieces = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode(['success' => true, 'allPieces' => $allPieces]);
        } catch (PDOException $e) {
            error_log("Erreur PDO pour getAllPiecesWithStock: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Erreur de base de données.']);
        }
        break;
    default:
        echo json_encode(['success' => false, 'message' => 'Action non reconnue.']);
        break;
}
?>