<?php
// ASE_Maintenance/message.php

// Ce fichier est destiné à être inclus dans d'autres pages PHP.
// On suppose que session_start() a déjà été appelé par le fichier parent ou php/config.php.
// Si ce n'est pas le cas, vous devrez décommenter et gérer session_start() ici.
// if (session_status() == PHP_SESSION_NONE) {
//     session_start();
// }

// Récupère l'ID et le nom de l'utilisateur courant depuis la session pour le JavaScript.
$current_user_id_for_js = $_SESSION['user_id'] ?? 'null';
$current_user_name_for_js = $_SESSION['user_name'] ?? 'null';

// URL de l'API pour les requêtes AJAX.
$api_url_for_js = 'php/api.php'; // Ajustez si votre api.php est ailleurs

// Définir un chemin absolu pour les fichiers CSS et JS
$base_path = ''; // Laissez vide si message.php est à la racine ou inclus depuis la racine
// Si message.php est dans un sous-dossier comme 'includes/', et les CSS/JS sont à la racine,
// $base_path devrait être '../' ou le chemin relatif correct.
// Pour cet exemple, nous supposons que css/message.css et js/message.js sont aux chemins relatifs standards.
?>

<button id="messaging-button" title="Ouvrir la Messagerie Interne">
    <i class="fas fa-comments"></i>
    <span id="unread-message-count" class="unread-badge hidden">0</span>
</button>

<div id="messaging-modal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-envelope-open-text mr-2"></i> Messagerie Interne</h3>
            <span class="close-button" id="messaging-close-button">&times;</span>
        </div>
        <div class="modal-body">
            <div class="tabs">
                <button id="new-conversation-button" class="btn btn-new-conversation ml-auto"><i class="fas fa-plus mr-1"></i> Nouvelle Discussion</button>
                <button class="tab-button active" data-tab="messages">Messages</button>
            </div>

            <div id="tab-messages" class="tab-content active">
                <div id="conversation-list-view">
                    <div class="loading-conversations">Chargement des conversations...</div>
                    </div>

                <div id="conversation-detail-view" style="display: none;">
                    <div class="conversation-header">
                        <button id="back-to-list-button" class="btn btn-back"><i class="fas fa-arrow-left mr-1"></i> Retour</button>
                        <h4 id="conversation-partner-name"></h4>
                    </div>
                    <div id="conversation-messages-display" class="messages-display">
                        </div>
                    <div class="message-input-area">
                        <textarea id="conversation-message-textarea" rows="2" placeholder="Écrivez votre message ici..."></textarea>
                        <button id="send-conversation-message-button" class="btn btn-send"><i class="fas fa-paper-plane mr-2"></i> Envoyer</button>
                    </div>
                </div>

                <div id="new-conversation-view" style="display: none;">
                    <div class="new-conversation-header">
                        <button id="back-to-list-from-new-button" class="btn btn-back"><i class="fas fa-arrow-left mr-1"></i> Retour</button>
                        <h4>Nouvelle Discussion</h4>
                    </div>
                    <div class="new-conversation-body">
                        <div class="form-group">
                            <label for="new-message-recipient">Destinataire :</label>
                            <select id="new-message-recipient" class="form-control" title="Sélectionnez un destinataire">
                                <option value="">Chargement des utilisateurs...</option>
                            </select>
                        </div>
                        <div class="form-group message-textarea-group">
                            <label for="new-message-textarea">Message :</label>
                            <textarea id="new-message-textarea" rows="5" placeholder="Écrivez votre message ici..."></textarea>
                        </div>
                        <button id="send-new-message-button" class="btn btn-send"><i class="fas fa-paper-plane mr-2"></i> Envoyer</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<audio id="notification-sound" src="sounds/notification_ding.mp3" preload="auto"></audio>
<link rel="stylesheet" href="<?php echo $base_path; ?>css/message.css">
<script>
    // Variables PHP passées au JavaScript
    const CURRENT_USER_ID = <?php echo $current_user_id_for_js; ?>;
    const CURRENT_USER_NAME = <?php echo json_encode($current_user_name_for_js); ?>;
    const API_URL = <?php echo json_encode($api_url_for_js); ?>;
</script>
<script src="<?php echo $base_path; ?>js/message.js"></script>