<?php
// ASE_Maintenance/magasinier.php
session_start();
require_once 'php/config.php';
if (
    empty($_SESSION['loggedin']) 
    || $_SESSION['loggedin'] !== true 
    || !isset($_SESSION['role']) 
    || $_SESSION['role'] !== 'Magasinier'
) {
    header('Location: index'); // Rediriger vers la page de connexion si non autorisé
    exit();
}
$message = $_SESSION['message'] ?? '';
$message_type = $_SESSION['message_type'] ?? '';
unset($_SESSION['message'], $_SESSION['message_type']);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de Bord Magasinier - ASE Maintenance</title>
    <link rel="icon" type="image/png" href="img/logo_ase.png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
    :root {
        --primary-bg: #010d18; --secondary-bg: #1a1a1a; --navbar-bg: rgba(1, 13, 24, 0.95);
        --text-color: #e0e0e0; --heading-color: #ffda47; --accent-color: #ffda47;
        --border-color: rgba(224, 224, 224, 0.1); --form-bg: #2b2b2b; --input-bg: #3c3c3c;
        --input-border: #505050; --table-header-bg: #101010; --table-row-even-bg: #282828;
        --btn-primary-bg: #007bff; --btn-primary-hover: #0056b3; --btn-warning-bg: #ffc107;
        --btn-warning-hover: #e0a800; --btn-danger-bg: #dc3545; --btn-danger-hover: #c82333;
        --btn-success-bg: #28a745; --btn-success-hover: #218838; --btn-info-bg: #17a2b8;
        --btn-info-hover: #138496; --success-bg: rgba(40, 167, 69, 0.2); --success-text: #28a745;
        --error-bg: rgba(220, 53, 69, 0.2); --error-text: #dc3545; --warning-bg: rgba(255, 193, 7, 0.2);
        --warning-text: #ffc107; --card-bg: #2b2b2b; --card-border: rgba(224, 224, 224, 0.15);
        --card-title-color: #ffda47; --stat-value-color: #e0e0e0; --stock-total-color: #17a2b8;
        --stock-entry-color: #28a745; --stock-exit-color: #dc3545; --stock-alert-color: #ffc107;
    }
    body { margin: 0; font-family: 'Inter', sans-serif; overflow-x: hidden; min-height: 100vh; display: flex; flex-direction: column; background-color: var(--primary-bg); color: var(--text-color); }
    .sparkles-container { position: fixed; top: 0; left: 0; width: 100vw; height: 100vh; pointer-events: none; overflow: hidden; z-index: -1; background-color: var(--primary-bg); }
    .spark { position: absolute; background-color: rgba(255, 255, 255, 0.7); border-radius: 50%; opacity: 0; animation: rain-sparkles 2s linear infinite, twinkle 1s ease-in-out infinite alternate; }
    @keyframes rain-sparkles { 0% { transform: translateY(-10px) translateX(var(--random-x, 0)); opacity: 0; } 10% { opacity: 1; } 90% { opacity: 1; } 100% { transform: translateY(calc(100vh + 10px)) translateX(var(--random-x, 0)); opacity: 0; } }
    @keyframes twinkle { from { opacity: 0.7; transform: scale(1); } to { opacity: 1; transform: scale(1.2); } }
    .navbar { display: flex; justify-content: space-between; align-items: center; background-color: var(--navbar-bg); padding: 15px 30px; color: white; position: sticky; top: 0; z-index: 10; width: 100%; box-sizing: border-box; border-bottom: 1px solid var(--border-color); box-shadow: 0 5px 15px rgba(0, 0, 0, 0.5); }
    .navbar-brand { display: flex; align-items: center; }
    .navbar-brand img { height: 45px; margin-right: 15px; }
    .navbar-brand span { font-size: 1em; font-weight: bold; color: white; }
    .navbar-nav { list-style: none; margin: 0; padding: 0; display: flex; }
    .navbar-nav li { margin-left: 30px; }
    .navbar-nav a { color: var(--text-color); text-decoration: none; padding: 8px 0; transition: color 0.3s ease, border-bottom 0.3s ease; position: relative; display: flex; align-items: center; font-size: 0.7em; }
    .navbar-nav a i { margin-right: 10px; font-size: 0.7em; }
    .navbar-nav a:hover, .navbar-nav a.active { color: var(--accent-color); font-weight: bold; }
    .navbar-nav a.active::after { content: ''; position: absolute; left: 0; bottom: -5px; width: 100%; height: 3px; background-color: var(--accent-color); border-radius: 2px; }
    .burger-menu { display: none; background: none; border: none; cursor: pointer; padding: 10px; z-index: 11; }
    .burger-menu .bar { width: 30px; height: 3px; background-color: white; margin: 6px 0; transition: transform 0.3s ease-in-out, opacity 0.3s ease-in-out; }
    .burger-menu.open .bar:nth-child(1) { transform: rotate(-45deg) translate(-5px, 6px); }
    .burger-menu.open .bar:nth-child(2) { opacity: 0; }
    .burger-menu.open .bar:nth-child(3) { transform: rotate(45deg) translate(-5px, -6px); }
    .navbar-nav.open { display: flex; flex-direction: column; align-items: center; position: absolute; top: 100%; left: 0; background-color: var(--navbar-bg); width: 100%; padding: 25px 0; box-shadow: 0 10px 20px rgba(0,0,0,0.3); z-index: 9; }
    .main-content { flex-grow: 1; padding: 40px; background-color: var(--secondary-bg); color: var(--text-color); max-width: 1400px; width: 95%; margin: 30px auto; border-radius: 10px; box-shadow: 0 8px 20px rgba(0, 0, 0, 0.6); }
    h1 { color: var(--heading-color); text-align: center; margin-bottom: 40px; font-size: 3em; border-bottom: 4px solid var(--accent-color); padding-bottom: 15px; letter-spacing: 1px; }
    h2.section-title { color: var(--heading-color); border-bottom: 2px solid var(--accent-color); padding-bottom: 12px; margin-top: 45px; margin-bottom: 25px; font-size: 2.2em; }
    .message { padding: 18px; margin-bottom: 30px; border-radius: 6px; font-weight: bold; font-size: 1.15em; display: flex; align-items: center; gap: 12px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3); }
    .message.success { background-color: var(--success-bg); color: var(--success-text); border: 1px solid var(--success-text); }
    .message.error { background-color: var(--error-bg); color: var(--error-text); border: 1px solid var(--error-text); }
    .message.warning { background-color: var(--warning-bg); color: var(--warning-text); border: 1px solid var(--warning-text); }
    .card-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 25px; margin-top: 30px; margin-bottom: 40px; }
    .card { background-color: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 25px; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3); display: flex; flex-direction: column; align-items: center; text-align: center; transition: transform 0.2s ease, box-shadow 0.2s ease; }
    .card:hover { transform: translateY(-5px); box-shadow: 0 8px 25px rgba(0, 0, 0, 0.5); }
    .card .icon { font-size: 3em; color: var(--accent-color); margin-bottom: 15px; }
    .card .title { font-size: 1.0em; font-weight: 600; color: var(--card-title-color); margin-bottom: 10px; }
    .card .value { font-size: 2.5em; font-weight: 700; color: var(--stat-value-color); }
    .card .unit { font-size: 1em; color: var(--text-color); opacity: 0.8; margin-top: 5px; }
    .card.total-stock .icon, .card.total-stock .value { color: var(--stock-total-color); }
    .card.total-entries .icon, .card.total-entries .value { color: var(--stock-entry-color); }
    .card.total-exits .icon, .card.total-exits .value { color: var(--stock-exit-color); }
    .card.out-of-stock .icon, .card.out-of-stock .value { color: var(--stock-alert-color); }
    .table-responsive { overflow-x: auto; margin-top: 30px; margin-bottom: 30px; border-radius: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.4); border: 1px solid var(--border-color); }
    table { width: 100%; border-collapse: collapse; background-color: var(--form-bg); min-width: 900px; }
    th, td { border: 1px solid var(--input-border); padding: 5px; text-align: left; font-size: 0.7em; color: var(--text-color); vertical-align: middle; }
    th { background-color: var(--table-header-bg); color: white; text-transform: uppercase; font-size: 0.8em; font-weight: bold; }
    tr:nth-child(even) { background-color: var(--table-row-even-bg); }
    tr:hover { background-color: #3a3a3a; transition: background-color 0.2s ease; }
    .pagination-controls { display: flex; justify-content: center; align-items: center; margin-top: 20px; gap: 10px; }
    .pagination-button { background-color: var(--accent-color); color: #2b2b2b; padding: 8px 15px; border-radius: 5px; cursor: pointer; font-weight: bold; transition: background-color 0.2s ease; }
    .pagination-button:hover:not(:disabled) { background-color: #e0b300; }
    .pagination-button:disabled { background-color: #505050; cursor: not-allowed; color: #b0b0b0; }
    .pagination-info { color: var(--text-color); font-weight: 500; }
    @media (max-width: 768px) { .navbar-nav { display: none; } .burger-menu { display: block; } .main-content { margin: 15px auto; padding: 20px; width: auto; } h1 { font-size: 2.2em; } .card-grid { grid-template-columns: 1fr; } }
</style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand"><img src="img/logo_ase.png" alt="Logo Entreprise"></div>
        <button class="burger-menu" aria-label="Ouvrir/Fermer le menu"><div class="bar"></div><div class="bar"></div><div class="bar"></div></button>
        <ul class="navbar-nav">
            <li><a href="magasinier" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="piece"><i class="fas fa-boxes"></i> Gestion pièce</a></li>
            <li><a href="commande"><i class="fas fa-shopping-cart"></i> Commande pièce</a></li>
            <li><a href="reception"><i class="fas fa-truck-loading"></i> Réception pièce</a></li>
            <li><a href="sortie"><i class="fas fa-truck-ramp-box"></i> Sortie pièce</a></li>
            <li><a href="pneu"><i class="fas fa-car"></i> Gestion Pneumatique</a></li>
            <li><a href="php/authentification.php?action=logout"><i style="color: red; font-size: 1.5em;" class="fa-solid fa-power-off"></i></a></li>
        </ul>
    </nav>
    <div class="sparkles-container"></div>
    <div class="main-content">
        <h1>Tableau de Bord Magasinier</h1>
        <?php if ($message): ?>
            <div class="message <?php echo htmlspecialchars($message_type); ?>"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
        <div id="messageBox" class="hidden"></div>
        <h2 class="section-title">Aperçu du Stock</h2>
        <div class="card-grid">
            <div class="card total-stock">
                <div class="icon"><i class="fas fa-warehouse"></i></div>
                <div class="title">Total Pièces en Stock</div>
                <div class="value" id="totalStockValue">0</div>
                <div class="unit">pièces</div>
            </div>
            <div class="card total-entries">
                <div class="icon"><i class="fas fa-truck-ramp-box fa-flip-horizontal"></i></div>
                <div class="title">Total Entrées (30j)</div>
                <div class="value" id="totalEntriesValue">0</div>
                <div class="unit">pièces</div>
            </div>
            <div class="card total-exits">
                <div class="icon"><i class="fas fa-truck-ramp-box"></i></div>
                <div class="title">Total Sorties (30j)</div>
                <div class="value" id="totalExitsValue">0</div>
                <div class="unit">pièces</div>
            </div>
            <div class="card out-of-stock">
                <div class="icon"><i class="fas fa-triangle-exclamation"></i></div>
                <div class="title">Pièces en rupture ou faible</div>
                <div class="value" id="outOfStockCount">0</div>
                <div class="unit">pièces</div>
            </div>
        </div>
        <h2 class="section-title">Historique Complet des Transactions</h2>
        <button id="exportTransactionsExcel" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded mb-4 flex items-center"><i class="fas fa-file-excel mr-2"></i> Exporter en Excel</button>
        <div class="mb-4">
            <label for="pieceTransactionFilter" class="block text-sm font-medium text-gray-300 mb-1">Filtrer par pièce (Nom ou Référence) :</label>
            <input type="text" id="pieceTransactionFilter" placeholder="Rechercher..." class="mt-1 block w-full rounded-md bg-gray-700 text-gray-50 border-gray-600 shadow-sm p-2">
        </div>
        <div class="table-responsive">
            <table id="transactionsTable">
                <thead><tr><th>Date</th><th>Nom Pièce</th><th>Réf.</th><th>Type</th><th>Qté</th><th>Stock Avant</th><th>Stock Après</th></tr></thead>
                <tbody id="transactionsTableBody"><tr><td colspan="7" class="text-center py-6">Chargement...</td></tr></tbody>
            </table>
        </div>
        <div class="pagination-controls" id="transactionsPagination">
            <button class="pagination-button" id="prevTransactionPage">Précédent</button>
            <span class="pagination-info" id="currentTransactionPageInfo"></span>
            <button class="pagination-button" id="nextTransactionPage">Suivant</button>
        </div>
        <h2 class="section-title">Liste Complète des Pièces en Stock</h2>
        <div class="mb-4">
            <label for="pieceStockFilter" class="block text-sm font-medium text-gray-300 mb-1">Filtrer par pièce (Nom ou Référence) :</label>
            <input type="text" id="pieceStockFilter" placeholder="Rechercher..." class="mt-1 block w-full rounded-md bg-gray-700 text-gray-50 border-gray-600 shadow-sm p-2">
        </div>
        <div class="table-responsive">
            <table id="allPiecesTable">
                <thead><tr><th>ID</th><th>Nom Pièce</th><th>Référence</th><th>Stock Actuel</th><th>Seuil Alerte</th></tr></thead>
                <tbody id="allPiecesTableBody"><tr><td colspan="5" class="text-center py-6">Chargement...</td></tr></tbody>
            </table>
        </div>
        <div class="pagination-controls" id="allPiecesPagination">
            <button class="pagination-button" id="prevAllPiecesPage">Précédent</button>
            <span class="pagination-info" id="currentAllPiecesPageInfo"></span>
            <button class="pagination-button" id="nextAllPiecesPage">Suivant</button>
        </div>
    </div>
    <?php include('message.php'); ?>
<script>
    let allTransactions = [], allInventoryPieces = [];
    let currentTransactionPage = 1, currentAllPiecesPage = 1;
    const transactionsPerPage = 10, allPiecesPerPage = 10;
    const API_URL_MAGASINIER = 'php/api_magasinier.php';

    async function fetchDashboardData() {
        try {
            const response = await fetch(API_URL_MAGASINIER, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'getDashboardMagasinierData' })
            });
            const data = await response.json();
            if (data.success) {
                // MODIFIÉ: Affiche le nombre de pièces, pas un montant
                document.getElementById('totalStockValue').textContent = parseInt(data.totalStockCount) || 0;
                document.getElementById('totalEntriesValue').textContent = parseInt(data.totalEntriesCount) || 0;
                document.getElementById('totalExitsValue').textContent = parseInt(data.totalExitsCount) || 0;
                document.getElementById('outOfStockCount').textContent = parseInt(data.outOfStockCount) || 0;
            }
        } catch (error) {
            console.error('Erreur réseau (Dashboard):', error);
        }
    }

    async function fetchAllTransactions() {
        const tableBody = document.getElementById('transactionsTableBody');
        tableBody.innerHTML = '<tr><td colspan="7" class="text-center py-6">Chargement de l\'historique...</td></tr>';
        try {
            const response = await fetch(API_URL_MAGASINIER, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'getAllTransactions' })
            });
            const data = await response.json();
            if (data.success && data.transactions) {
                allTransactions = data.transactions;
                currentTransactionPage = 1;
                renderTransactionsTable(allTransactions);
            } else {
                tableBody.innerHTML = '<tr><td colspan="7" class="text-center py-6">Aucune transaction.</td></tr>';
            }
        } catch (error) {
            console.error('Erreur réseau (Transactions):', error);
        }
    }

    function renderTransactionsTable(data) {
        const tableBody = document.getElementById('transactionsTableBody');
        tableBody.innerHTML = '';
        const startIndex = (currentTransactionPage - 1) * transactionsPerPage;
        const paginatedData = data.slice(startIndex, startIndex + transactionsPerPage);
        if (paginatedData.length === 0) {
            tableBody.innerHTML = '<tr><td colspan="7" class="text-center py-6">Aucun résultat.</td></tr>';
            updatePaginationControls('transactions', 0, 0);
            return;
        }
        paginatedData.forEach(t => {
            const row = tableBody.insertRow();
            row.innerHTML = `
                <td>${new Date(t.date).toLocaleString('fr-FR', {dateStyle: 'short', timeStyle: 'short'})}</td>
                <td>${t.nom_piece}</td>
                <td>${t.reference}</td>
                <td>${t.type}</td>
                <td>${t.type === 'Réception' ? '+' : '-'}${t.quantite_receptionnee || t.quantite_sortie}</td>
                <td>${t.stock_avant_op}</td>
                <td>${t.stock_apres_op}</td>
            `;
        });
        updatePaginationControls('transactions', data.length, transactionsPerPage);
    }

    async function fetchAllPiecesWithStock() {
        const tableBody = document.getElementById('allPiecesTableBody');
        tableBody.innerHTML = '<tr><td colspan="5" class="text-center py-6">Chargement...</td></tr>';
        try {
            const response = await fetch(API_URL_MAGASINIER, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: 'getAllPiecesWithStock' })
            });
            const data = await response.json();
            if (data.success && data.allPieces) {
                allInventoryPieces = data.allPieces;
                currentAllPiecesPage = 1;
                renderAllPiecesTable(allInventoryPieces);
            } else {
                tableBody.innerHTML = '<tr><td colspan="5" class="text-center py-6">Aucune pièce.</td></tr>';
            }
        } catch (error) {
            console.error('Erreur réseau (Pièces):', error);
        }
    }

    function renderAllPiecesTable(data) {
        const tableBody = document.getElementById('allPiecesTableBody');
        tableBody.innerHTML = '';
        const startIndex = (currentAllPiecesPage - 1) * allPiecesPerPage;
        const paginatedData = data.slice(startIndex, startIndex + allPiecesPerPage);
        if (paginatedData.length === 0) {
            tableBody.innerHTML = '<tr><td colspan="5" class="text-center py-6">Aucun résultat.</td></tr>';
            updatePaginationControls('allPieces', 0, 0);
            return;
        }
        paginatedData.forEach(p => {
            const row = tableBody.insertRow();
            row.innerHTML = `<td>${p.id_piece}</td><td>${p.nom_piece}</td><td>${p.reference}</td><td>${p.stock_initial}</td><td>${p.seuil_alerte}</td>`;
        });
        updatePaginationControls('allPieces', data.length, allPiecesPerPage);
    }

    function updatePaginationControls(type, totalItems, perPage) {
        const currentPage = type === 'transactions' ? currentTransactionPage : currentAllPiecesPage;
        const totalPages = Math.ceil(totalItems / perPage);
        const info = document.getElementById(type === 'transactions' ? 'currentTransactionPageInfo' : 'currentAllPiecesPageInfo');
        const prev = document.getElementById(type === 'transactions' ? 'prevTransactionPage' : 'prevAllPiecesPage');
        const next = document.getElementById(type === 'transactions' ? 'nextTransactionPage' : 'nextAllPiecesPage');
        info.textContent = totalPages > 0 ? `Page ${currentPage} sur ${totalPages}` : 'Page 0/0';
        prev.disabled = currentPage === 1;
        next.disabled = currentPage === totalPages || totalPages === 0;
    }

    function goToPage(type, pageNum) {
        const filterElId = type === 'transactions' ? 'pieceTransactionFilter' : 'pieceStockFilter';
        const dataArray = type === 'transactions' ? allTransactions : allInventoryPieces;
        const renderFunc = type === 'transactions' ? renderTransactionsTable : renderAllPiecesTable;
        const filterValue = document.getElementById(filterElId).value.toLowerCase();
        const filtered = dataArray.filter(item => item.nom_piece.toLowerCase().includes(filterValue) || item.reference.toLowerCase().includes(filterValue));
        const totalPages = Math.ceil(filtered.length / (type === 'transactions' ? transactionsPerPage : allPiecesPerPage));
        if (pageNum >= 1 && pageNum <= totalPages) {
            if (type === 'transactions') currentTransactionPage = pageNum; else currentAllPiecesPage = pageNum;
            renderFunc(filtered);
        }
    }

    document.getElementById('exportTransactionsExcel').addEventListener('click', () => {
        const filterValue = document.getElementById('pieceTransactionFilter').value.toLowerCase();
        const filtered = allTransactions.filter(t => t.nom_piece.toLowerCase().includes(filterValue) || t.reference.toLowerCase().includes(filterValue));
        if (filtered.length === 0) return;
        const exportData = [["Date", "Nom Pièce", "Réf.", "Type", "Qté", "Stock Avant", "Stock Après"]];
        filtered.forEach(t => {
            exportData.push([
                new Date(t.date).toLocaleString('fr-FR'), t.nom_piece, t.reference, t.type,
                t.type === 'Réception' ? `+${t.quantite_receptionnee}` : `-${t.quantite_sortie}`,
                t.stock_avant_op, t.stock_apres_op
            ]);
        });
        const ws = XLSX.utils.aoa_to_sheet(exportData);
        ws['!cols'] = exportData[0].map((_, i) => ({ wch: Math.max(...exportData.map(row => (row[i] ? row[i].toString().length : 0))) + 2 }));
        const wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Transactions");
        XLSX.writeFile(wb, `historique_transactions_${new Date().toISOString().slice(0,10)}.xlsx`);
    });

    document.addEventListener('DOMContentLoaded', () => {
        ['prevTransactionPage', 'nextTransactionPage'].forEach(id => document.getElementById(id).addEventListener('click', () => goToPage('transactions', currentTransactionPage + (id.includes('next') ? 1 : -1))));
        ['prevAllPiecesPage', 'nextAllPiecesPage'].forEach(id => document.getElementById(id).addEventListener('click', () => goToPage('allPieces', currentAllPiecesPage + (id.includes('next') ? 1 : -1))));
        ['pieceTransactionFilter', 'pieceStockFilter'].forEach(id => document.getElementById(id).addEventListener('input', () => goToPage(id.includes('Transaction') ? 'transactions' : 'allPieces', 1)));
        fetchDashboardData();
        fetchAllTransactions();
        fetchAllPiecesWithStock();
        const burgerMenu = document.querySelector('.burger-menu'), navbarNav = document.querySelector('.navbar-nav');
        burgerMenu.addEventListener('click', () => { navbarNav.classList.toggle('open'); burgerMenu.classList.toggle('open'); });
    });
</script>
</body>
</html>