document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('loginForm');
    const messageDiv = document.getElementById('message');

    if (loginForm) {
        loginForm.addEventListener('submit', function(event) {
            event.preventDefault(); // Empêche le rechargement de la page

            messageDiv.textContent = ''; // Efface les messages précédents
            messageDiv.classList.remove('success'); // Supprime la classe succès
            messageDiv.style.color = '#dc3545'; // Définit la couleur d'erreur par défaut

            const formData = new FormData(loginForm);

            fetch('php/authentification.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) { // Vérifie si la réponse HTTP est OK (statut 200)
                    throw new Error('Network response was not ok ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    messageDiv.textContent = data.message || 'Connexion réussie ! Redirection...';
                    messageDiv.classList.add('success');
                    messageDiv.style.color = '#6aff6b'; // Utilisez la couleur verte du CSS pour le succès

                    // Redirection basée sur le rôle APRES un court délai pour que l'utilisateur voie le message
                    setTimeout(() => {
                        switch (data.role) {
                            case 'Administrateur':
                                window.location.href = 'tableau_bord';
                                break;
                            case 'Magasinier':
                                window.location.href = 'magasinier';
                                break;
                            case 'Technicien':
                                window.location.href = 'technicien';
                                break;
                            
                        }
                    }, 1500); // Redirige après 1.5 seconde
                } else {
                    messageDiv.textContent = data.message || 'Erreur de connexion.';
                    // Ne pas changer la couleur ici, car elle est déjà définie en rouge par défaut
                }
            })
            .catch(error => {
                console.error('Erreur Fetch:', error);
                messageDiv.textContent = 'Une erreur est survenue lors de la connexion. Veuillez vérifier votre connexion internet ou réessayer.';
                messageDiv.style.color = '#dc3545'; // S'assurer que le message d'erreur est rouge
            });
        });
    }
});

// Fonction pour afficher/masquer le mot de passe avec icônes Font Awesome
function togglePasswordVisibility() {
    const passwordField = document.getElementById('password');
    const toggleIcon = document.querySelector('.toggle-password .fas');
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordField.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
}