<?php
// ASE_Maintenance/index.php

// Démarrer la session au tout début du script
session_start();

// Inclure le fichier de configuration (pour accéder à ENVIRONMENT et la fonction getDbConnection si besoin,
// même si pour la page de connexion, c'est principalement pour la session.)
require_once 'php/config.php';

// Si l'utilisateur est déjà connecté, le rediriger vers son tableau de bord approprié
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    $role = $_SESSION['role'] ?? 'Client'; // Par défaut 'Client' si le rôle n'est pas défini (sécurité)

    switch ($role) {
        case 'Administrateur':
            header('Location: tableau_bord');
            exit();
        case 'Magasinier':
            header('Location: magasinier'); // Créez ce fichier plus tard
            exit();
        case 'Technicien':
            header('Location: technicien'); // Créez ce fichier plus tard
            exit();
        case 'Admin_ase':
            header('Location: acceuiladmin'); // Nouvelle redirection pour Admin_ase
            exit();
        case 'Magasinier_ase':
            header('Location: acceuilstock'); // Nouvelle redirection pour Magasinier_ase
            exit();
        case 'Vendeur_ase':
            header('Location: acceuilvendeur'); // Nouvelle redirection pour Vendeur_ase
            exit();
    }
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - ASE Maintenance</title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="icon" type="image/png" href="img/logo_ase.png">
</head>
<style>
    /* Variables CSS */
:root {
     --gradient-bg: linear-gradient(
        135deg,
         #ffffff 5%,   /* blanc dominant */
         #002147 85%,  
        #2ecc71 100%   /* vert doux */
    );
    /* Couleurs pour le dégradé */
    --gradient-blue-dark: #ffffff; /* Bleu marine foncé */
    --gradient-black: #0d0d0d;   /* Noir */
    --gradient-green-accent: #2ecc71; /* Vert forêt ou émeraude pour l'accent */
    --gradient-light-blue:#002147; /* Bleu moyen pour des accents */

    --primary-color: #3f6ad8; /* Ancien bleu principal, peut être ajusté ou retiré si non utilisé */
    --primary-color-dark: #2c52b3;

    --text-color-dark: #333; /* Texte des labels */
    --text-color-light: #666; /* Texte des placeholders */
    --card-text-color: #e0e0e0; /* Texte sur le fond sombre de la carte */


    --border-color: #e0e0e0; /* Bordure des inputs */
    --input-bg-color: #fcfcfc; /* Fond des inputs */
    --icon-color: #a0a0a0; /* Couleur des icônes des inputs */

    /* Ombres */
    --shadow-base: rgba(0, 0, 0, 0.2); /* Ombre plus visible sur un fond sombre */
    --input-focus-shadow: rgba(74, 117, 167, 0.6); /* Ombre focus adaptée au nouveau bleu */
    --button-shadow: rgba(63, 106, 216, 0.4); /* Ombre du bouton */
    
}

/* Styles généraux */
body {
    font-family: 'Montserrat', sans-serif;
    margin: 0;
    padding: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    /* NOUVEAU : Dégradé pour le background général du body */
   background: var(--gradient-bg);
    overflow: hidden;
    color: var(--text-color-light);
}

.login-container {
    display: flex;
    /* NOUVEAU : Dégradé pour le background de la carte de connexion */
    background: var(--gradient-bg);
    border-radius: 12px;
    box-shadow: 0 10px 40px var(--shadow-base);
    overflow: hidden;
    max-width: 1000px;
    width: 95%;
    min-height: 550px;
}

.map-background {
    flex: 1.2;
    /* IMPORTANT : Assurez-vous que l'image contact-bg.png est bien dans le dossier img/ */
    background-image: url('img/contact-bg.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    display: flex;
    justify-content: center;
    align-items: center;
    position: relative;
    /* Optionnel : Si l'image de fond ne correspond pas parfaitement au thème sombre,
       vous pouvez ajouter un overlay semi-transparent */
    /*
    &::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.3); // Légère superposition noire
    }
    */
}

.login-card {
    flex: 1;
    padding: 60px 50px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    background-color: var(--card-background); /* Peut être une couleur unie claire ou un dégradé plus subtil */
    /* Si vous voulez que la carte de login elle-même ait le même dégradé que le container, enlever background-color: var(--card-background); */
    /* Et la couleur des textes des labels et placeholders devront être clairs */
}

.login-header {
    text-align: center;
    margin-bottom: 50px;
}

.logo {
    max-width: 180px;
    height: auto;
    display: block;
    margin: 0 auto;
    filter: drop-shadow(0 0 5px rgba(255, 255, 255, 0.5)); /* Pour que le logo ressorte sur un fond sombre */
}

/* Formulaire et champs */
form {
    width: 100%;
    max-width: 380px;
}

.form-group {
    margin-bottom: 25px;
    width: 100%;
}

.form-group label {
    display: block;
    margin-bottom: 10px;
    color: var(--card-text-color); /* Couleur de texte claire pour les labels */
    font-weight: 600;
    font-size: 1em;
}

.input-icon-wrapper {
    position: relative;
    display: flex;
    align-items: center;
    border: 1px solid var(--border-color); /* La bordure pourrait aussi être plus claire */
    border-radius: 8px;
    background-color: var(--input-bg-color); /* Fond des inputs reste clair pour la lisibilité */
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

.input-icon-wrapper:focus-within {
    border-color: var(--gradient-green-accent); /* Couleur d'accent vert au focus */
    box-shadow: 0 0 0 3px rgba(46, 139, 87, 0.4); /* Ombre focus verte */
}

.input-icon-wrapper .icon {
    position: absolute;
    left: 18px;
    color: var(--icon-color); /* Couleur des icônes */
    font-size: 1.1em;
}

.form-group input {
    flex-grow: 1;
    padding: 18px 20px 18px 50px;
    border: none;
    background-color: transparent;
    font-size: 1.1em;
    color: var(--text-color-dark); /* La couleur du texte tapé dans l'input reste sombre pour lisibilité */
    outline: none;
    box-sizing: border-box;
}

.form-group input::placeholder {
    color: var(--text-color-light); /* Couleur des placeholders */
    opacity: 0.7;
}

.password-wrapper {
    position: relative;
    width: 100%;
}

.toggle-password {
    position: absolute;
    right: 18px;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;
    color: var(--icon-color);
    font-size: 1.1em;
    transition: color 0.2s ease;
}

.toggle-password:hover {
    color: var(--gradient-green-accent); /* Vert au survol */
}

/* Bouton de connexion */
.btn-login {
    width: 100%;
    padding: 15px 25px;
    /* NOUVEAU : Dégradé pour le bouton de connexion */
    background: linear-gradient(90deg, var(--gradient-green-accent) 0%, var(--gradient-light-blue) 100%);
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 1.2em;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease; /* Transition sur toutes les propriétés */
    margin-top: 25px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    box-shadow: 0 5px 15px rgba(46, 139, 87, 0.4); /* Ombre du bouton verte */
}

.btn-login .fas {
    font-size: 1em;
}

.btn-login:hover {
    background: linear-gradient(90deg, var(--gradient-light-blue) 0%, var(--gradient-green-accent) 100%); /* Inverser le dégradé au survol */
    transform: translateY(-3px); /* Effet plus prononcé */
    box-shadow: 0 10px 20px rgba(46, 139, 87, 0.6); /* Ombre plus forte au survol */
}

.btn-login:active {
    transform: translateY(0);
    box-shadow: none;
}

/* Messages d'erreur/succès */
.message {
    margin-top: 20px;
    font-size: 0.95em;
    text-align: center;
    color: #ff6b6b; /* Rouge plus doux pour erreur */
    min-height: 25px;
    font-weight: 500;
}

.message.success {
    color: #6aff6b; /* Vert plus lumineux pour succès */
}

/* Responsive adjustments (conserver tels quels sauf si besoin d'ajustements spécifiques pour le gradient) */
@media (max-width: 900px) {
    .login-container {
        flex-direction: column;
        max-width: 500px;
        min-height: auto;
    }

    .map-background {
        height: 200px;
        border-radius: 12px 12px 0 0;
    }

    .login-card {
        padding: 40px 30px;
        border-radius: 0 0 12px 12px;
    }

    .login-header {
        margin-bottom: 30px;
    }

    .logo {
        max-width: 120px;
    }

    form {
        max-width: none;
    }

    .form-group label {
        font-size: 1em;
    }

    .form-group input {
        font-size: 1em;
        padding: 15px 15px 15px 45px;
    }

    .input-icon-wrapper .icon {
        left: 15px;
    }

    .toggle-password {
        right: 15px;
    }
}
    
</style>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <img src="img/logo_ase.png" alt="Logo ASE" class="logo">
                </div>
            <form id="loginForm">
                <div class="form-group">
                    <label for="username" style="color: #002147;">Nom d'utilisateur</label>
                    <div class="input-icon-wrapper">
                        <i class="fas fa-user icon"></i> <input type="text" id="username" name="username" placeholder="Entrez votre nom d'utilisateur" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="password"  style="color:  #002147;">Mot de passe</label>
                    <div class="input-icon-wrapper">
                        <i class="fas fa-lock icon"></i> <input type="password" id="password" name="password" placeholder="Entrez votre mot de passe" required>
                        <span class="toggle-password" onclick="togglePasswordVisibility()">
                            <i class="fas fa-eye"></i> </span>
                    </div>
                </div>
                <button type="submit" class="btn-login">
                </i> Se connecter </button>
                <div id="message" class="message"></div>
            </form>
        </div>
        <div class="map-background"></div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('loginForm');
    const messageDiv = document.getElementById('message');

    if (loginForm) {
        loginForm.addEventListener('submit', function(event) {
            event.preventDefault(); // Empêche le rechargement de la page

            messageDiv.textContent = ''; // Efface les messages précédents
            messageDiv.classList.remove('success'); // Supprime la classe succès
            messageDiv.style.color = '#dc3545'; // Définit la couleur d'erreur par défaut

            const formData = new FormData(loginForm);

            fetch('php/authentification.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) { // Vérifie si la réponse HTTP est OK (statut 200)
                    throw new Error('Network response was not ok ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    messageDiv.textContent = data.message || 'Connexion réussie ! Redirection...';
                    messageDiv.classList.add('success');
                    messageDiv.style.color = '#6aff6b'; // Utilisez la couleur verte du CSS pour le succès

                    // Redirection basée sur le rôle APRES un court délai pour que l'utilisateur voie le message
                    setTimeout(() => {
                        switch (data.role) {
                            case 'Administrateur':
                                window.location.href = 'tableau_bord';
                                break;
                            case 'Magasinier':
                                window.location.href = 'magasinier';
                                break;
                            case 'Technicien':
                                window.location.href = 'technicien';
                                break;
                            
                        }
                    }, 1500); // Redirige après 1.5 seconde
                } else {
                    messageDiv.textContent = data.message || 'Erreur de connexion.';
                    // Ne pas changer la couleur ici, car elle est déjà définie en rouge par défaut
                }
            })
            .catch(error => {
                console.error('Erreur Fetch:', error);
                messageDiv.textContent = 'Une erreur est survenue lors de la connexion. Veuillez vérifier votre connexion internet ou réessayer.';
                messageDiv.style.color = '#dc3545'; // S'assurer que le message d'erreur est rouge
            });
        });
    }
});

// Fonction pour afficher/masquer le mot de passe avec icônes Font Awesome
function togglePasswordVisibility() {
    const passwordField = document.getElementById('password');
    const toggleIcon = document.querySelector('.toggle-password .fas');
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordField.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
}
    </script>
</body>
</html>