<?php
require_once 'php/config.php';
require_once 'dompdf-3.1.0/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$pdo = getDbConnection();
$numero_facture = $_GET['numero_facture'] ?? '';

$stmt = $pdo->prepare("
    SELECT f.*, v.immatriculation, v.marque, c.nom_client, c.contact_client, c.nif, c.stat
    FROM facturations f
    JOIN pointage_vehicule p ON f.id_pointage = p.id_pointage
    JOIN vehicules v ON p.id_vehicule = v.id_vehicule
    JOIN clients c ON f.id_client = c.id_client
    WHERE f.numero_facture = ?
");
$stmt->execute([$numero_facture]);
$factures = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Préparer le logo en Base64 pour Dompdf
$logo_path = 'img/logo_ase.png'; // Assurez-vous que le chemin est correct
$logo_base64 = '';
if (file_exists($logo_path)) {
    $type = pathinfo($logo_path, PATHINFO_EXTENSION);
    $data = file_get_contents($logo_path);
    $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
}

if (!$factures) {
    die("Facture introuvable");
}

$client = $factures[0];
$total_ht = array_sum(array_column($factures, 'montant_ht'));
$total_tva = array_sum(array_column($factures, 'montant_tva'));
$total_ttc = array_sum(array_column($factures, 'montant_ttc'));

$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

ob_start();
?>
<html>
<head>
<meta charset="UTF-8">
<style>
    html { height: 100%; }
    body {
        font-family: sans-serif;
        margin: 0;
        padding: 0;
        font-size: 10px;
        padding-bottom: 10mm;
    }
    @page { margin: 1cm; }

    /* Logo + header facture */
    .logo-container { position: absolute; top: 0; left: 0; width: 70mm; height: 25mm; }
    .logo-container img { max-width: 90%; height: auto; display: block; }
    .first-page-header-box { position: absolute; top: 0; right: 0; height: 20mm; width: 50mm; text-align: center; border: 1px solid black; padding: 8px 12px; font-size: 1.2em; font-weight: bold; box-sizing: border-box; margin-top: 10px; display: flex; flex-direction: column; justify-content: center; align-items: center; }
    .first-page-header-box p { margin: 2px 0; line-height: 1.4; }

    /* Contenu principal */
    .document-container { width: 100%; position: relative; margin-top: 35mm; }

    .client-info p { margin: 2px 0;}

    /* Tableau facturation */
    table { width: 100%; border-collapse: collapse; margin-top: 2mm; margin-bottom: 5mm; }
    th, td { border: 1px solid black; padding: 8px 6px; font-size: 0.9em; vertical-align: middle; }
    th { background-color: #e0e0e0; text-transform: uppercase; font-weight: bold; text-align: center; }
    td { text-align: right; }
    td:first-child, td:nth-child(2), td:nth-child(3) { text-align: center; }

    /* Totaux */
    .totals-summary-box { width: 30%; margin-left: auto; border: 1px solid black; padding: 5px; clear: both; page-break-inside: avoid; }
    .total-line { display: flex; justify-content: space-between; margin-bottom: 2px; }
    .final-total { font-size: 1.2em; font-weight: bold; }

    /* Pied de page */
    #footer-content { position: fixed; bottom: 0; left: 0; right: 0; text-align: center; font-size: 0.7em; border-top: 1px solid black; padding-top: 5px; }
</style>
</head>
<body>

<div class="logo-container">
        <?php if (!empty($logo_base64)): ?>
            <img src="<?= $logo_base64 ?>" alt="Logo ASE">
        <?php else: ?>
            <p style="color: red; font-size: 0.8em;">Logo non trouvé</p>
        <?php endif; ?>
    </div>
<div class="first-page-header-box">
    <p>FACTURE</p>
    <p>N° <?= htmlspecialchars($numero_facture) ?></p>
    <p><?= date('d/m/Y') ?></p>
</div>

<div class="document-container">
    <div class="client-info">
        <p style="font-size: 1.5em;"><strong><?= htmlspecialchars($client['nom_client']) ?></strong></p>
        <p style="font-size: 1.2em;"><?= htmlspecialchars($client['contact_client']) ?></p>
        <p style="font-size: 1.2em;"><?= htmlspecialchars($client['nif']) ?></p>
        <p style="font-size: 1.2em;"><?= htmlspecialchars($client['stat']) ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Véhicule</th>
                <th>Kilométrage</th>
                <th>Tarif/km</th>
                <th>Montant HT</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($factures as $i => $f): ?>
            <tr>
                <td><?= $i+1 ?></td>
                <td style="text-align:left;"><?= htmlspecialchars($f['immatriculation'].' / '.$f['marque']) ?></td>
                <td><?= number_format($f['montant_ht'] / $f['tarif_km'], 0, ',', ' ') ?> km</td>
                <td><?= number_format($f['tarif_km'], 2, ',', ' ') ?></td>
                <td><?= number_format($f['montant_ht'], 2, ',', ' ') ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="totals-summary-box">
        <div class="total-line"><span>Total HT:</span> <span><?= number_format($total_ht, 2, ',', ' ') ?> Ar</span></div>
        <div class="total-line"><span>Total TVA:</span> <span><?= number_format($total_tva, 2, ',', ' ') ?> Ar</span></div>
        <div class="total-line final-total"><span>Total TTC:</span> <span><?= number_format($total_ttc, 2, ',', ' ') ?> Ar</span></div>
    </div>
</div>

<div id="footer-content">
        <p><strong>AUTO SERVICE DE L'EST SARL</strong></p>
        <p>NIF:3002015172 - STAT:77100312000183</p>
        <p>Rue de commerce Toamasina 501 - Tél:+261 34 05 216 90 - Email:contact@ase.mg </p>
        <p>RIB BGFI:00012 01250 41015401011 63  - RIB BFV:00008 00490 02001012003 70 </p>
</div>

</body>
</html>
<?php
$html = ob_get_clean();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Facture_$numero_facture.pdf", ["Attachment" => true]);
