<?php
// ASE_Maintenance/generate_facture_globales_pdf.php

session_start();

require_once 'php/config.php';

// Inclusion de la bibliothèque Dompdf
require_once 'dompdf-3.1.0/dompdf/vendor/autoload.php';
use Dompdf\Dompdf;
use Dompdf\Options;

// Définit le fuseau horaire à Antananarivo, Madagascar
date_default_timezone_set('Indian/Antananarivo');

// Vérification de l'authentification et du rôle Administrateur ou Magasinier
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || ($_SESSION['role'] !== 'Administrateur' && $_SESSION['role'] !== 'Magasinier')) {
    header('Location: index.php'); // Rediriger si non autorisé
    exit();
}

$pdo = getDbConnection();

// Récupération des filtres depuis l'URL
$filter_vehicule_sigle = trim($_GET['filter_vehicule_sigle'] ?? 'all');
$filter_start_date = trim($_GET['filter_start_date'] ?? '');
$filter_end_date = trim($_GET['filter_end_date'] ?? '');

$sql_where = " WHERE 1=1 ";
$params = [];

// Filtrage par sigle du véhicule
if (!empty($filter_vehicule_sigle) && $filter_vehicule_sigle !== 'all') {
    $sql_where .= " AND v.sigle = ?";
    $params[] = $filter_vehicule_sigle;
}

// Filtrage par intervalle de dates si spécifié
if (!empty($filter_start_date)) {
    $sql_where .= " AND sp.date_sortie >= ?";
    $params[] = $filter_start_date;
}
if (!empty($filter_end_date)) {
    $sql_where .= " AND sp.date_sortie <= ?";
    $params[] = $filter_end_date;
}
$filter_id_client = trim($_GET['filter_id_client'] ?? 'all');

// Filtrage par client
if (!empty($filter_id_client) && $filter_id_client !== 'all') {
    $sql_where .= " AND cli.id_client = ?";
    $params[] = $filter_id_client;
}

// Initialiser les variables d'information client et véhicule
$client_nom = 'N/A';
$client_contact = 'N/A';
$client_type = 'N/A';
$client_nif = 'N/A'; // Nouvelle variable pour le NIF
$client_stat = 'N/A'; // Nouvelle variable pour le STAT
$vehicule_immatriculation = ''; // Nouvelle variable pour l'immatriculation du véhicule filtré

// Si un sigle de véhicule spécifique est filtré, essayer d'obtenir son client associé et son immatriculation
if (!empty($filter_vehicule_sigle) && $filter_vehicule_sigle !== 'all') {
    $stmt_vehicule_client = $pdo->prepare("
        SELECT v.immatriculation, c.nom_client, c.contact_client, c.type_client, c.nif, c.stat
        FROM vehicules v
        JOIN clients c ON v.id_client = c.id_client
        WHERE v.sigle = ?
    ");
    $stmt_vehicule_client->execute([$filter_vehicule_sigle]);
    $vehicule_info = $stmt_vehicule_client->fetch(PDO::FETCH_ASSOC);
    if ($vehicule_info) {
        $vehicule_immatriculation = $vehicule_info['immatriculation'];
        $client_nom = $vehicule_info['nom_client'];
        $client_contact = $vehicule_info['contact_client'];
        $client_type = $vehicule_info['type_client'];
        $client_nif = $vehicule_info['nif'];
        $client_stat = $vehicule_info['stat'];
    }
}

// Récupération des données pour la facture PDF (toutes les données sans pagination)
// Nous allons récupérer les détails des pièces pour chaque sortie
$stmt_sorties = $pdo->prepare("
    SELECT
        sp.id_sortie,
        sp.date_sortie,
        sp.notes,
        sp.total_ht AS sortie_total_ht,
        sp.total_tva AS sortie_total_tva,
        sp.total_ttc AS sortie_total_ttc,
        i.id_intervention,
        i.date_intervention,
        v.immatriculation,
        v.sigle,
        v.marque,
        cli.id_client, -- Ajout de l'ID client pour la logique ci-dessous
        cli.nom_client,
        cli.contact_client,
        cli.type_client,
        cli.nif,    -- Ajout du NIF ici aussi pour la logique 'all'
        cli.stat,   -- Ajout du STAT ici aussi pour la logique 'all'
        u.nom_utilisateur AS magasinier_nom
    FROM
        sorties_pieces sp
    JOIN interventions i ON sp.id_intervention = i.id_intervention
    JOIN vehicules v ON i.id_vehicule = v.id_vehicule
    LEFT JOIN clients cli ON i.id_client = cli.id_client
    LEFT JOIN utilisateurs u ON sp.id_magasinier = u.id_utilisateur
    " . $sql_where . "
    ORDER BY sp.date_sortie ASC
");
$stmt_sorties->execute($params);
$sorties_data = $stmt_sorties->fetchAll(PDO::FETCH_ASSOC);

// Si le filtre de véhicule était 'all' et que nous avons des sorties, vérifier s'il y a plusieurs clients
if ($filter_vehicule_sigle === 'all' && !empty($sorties_data)) {
    $distinct_client_ids = [];
    foreach ($sorties_data as $sortie) {
        if (!empty($sortie['id_client'])) {
            $distinct_client_ids[] = $sortie['id_client'];
        }
    }
    $distinct_client_ids = array_unique($distinct_client_ids);

    if (count($distinct_client_ids) > 1) {
        $client_nom = 'Plusieurs clients';
        $client_contact = 'Voir détails dans le tableau';
        $client_type = 'Mixte';
        $client_nif = 'N/A'; // Réinitialiser si plusieurs clients pour éviter la confusion
        $client_stat = 'N/A'; // Réinitialiser si plusieurs clients pour éviter la confusion
    } else if (count($distinct_client_ids) === 1) {
        // Si un seul client même avec 'all' (ex: toutes les sorties pour le même client)
        $single_client_id = $distinct_client_ids[0];
        $stmt_client_info = $pdo->prepare("SELECT nom_client, contact_client, type_client, nif, stat FROM clients WHERE id_client = ?");
        $stmt_client_info->execute([$single_client_id]);
        $client_details = $stmt_client_info->fetch(PDO::FETCH_ASSOC);
        if ($client_details) {
            $client_nom = $client_details['nom_client'];
            $client_contact = $client_details['contact_client'];
            $client_type = $client_details['type_client'];
            $client_nif = $client_details['nif'];
            $client_stat = $client_details['stat'];
        }
    }
}


// Pour chaque sortie, récupérer les détails des pièces
foreach ($sorties_data as &$sortie) {
    $stmt_details_pieces = $pdo->prepare("
        SELECT
            dsp.quantite_sortie,
            dsp.prix_unitaire_ht_au_moment_sortie,
            dsp.tva_taux_au_moment_sortie,
            p.nom_piece,
            p.reference,
            p.code_piece
        FROM
            details_sortie_piece dsp
        JOIN piece p ON dsp.id_piece = p.id_piece
        WHERE dsp.id_sortie = :id_sortie
    ");
    $stmt_details_pieces->execute([':id_sortie' => $sortie['id_sortie']]);
    $sortie['details_pieces'] = $stmt_details_pieces->fetchAll(PDO::FETCH_ASSOC);
}
unset($sortie); // Rompre la référence de la dernière itération

// Calcul du total général TTC pour la période et le véhicule filtrés
$total_general_ht = 0;
$total_general_tva = 0;
$total_general_ttc = 0;

foreach ($sorties_data as $sortie) {
    $total_general_ht += $sortie['sortie_total_ht'];
    $total_general_tva += $sortie['sortie_total_tva'];
    $total_general_ttc += $sortie['sortie_total_ttc'];
}

// Informations de l'entreprise (fixes)
$nom_entreprise = "AUTO SERVICE DE L'EST SARL";
$adresse_entreprise = "Rue de commerce Toamasina 501";
$nif_entreprise = "3002015172";
$stat_entreprise = "77100312000183";
$rc_entreprise = "*******"; // À remplir si vous avez cette information
$tel_entreprise = "+261 34 05 216 90";
$email_entreprise = "contact@ase.mg";
$rib_bgfi = "00012 01250 41015401011 63";
$rib_bfv = "00008 00490 02001012003 70";

// Préparer le logo en Base64 pour Dompdf
$logo_path = 'img/logo_ase.png'; // Assurez-vous que le chemin est correct
$logo_base64 = '';
if (file_exists($logo_path)) {
    $type = pathinfo($logo_path, PATHINFO_EXTENSION);
    $data = file_get_contents($logo_path);
    $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
}

/**
 * Formate un nombre pour l'affichage monétaire.
 * @param float $n Le nombre à formater.
 * @return string Le nombre formaté avec des espaces comme séparateur de milliers et deux décimales.
 */
function format_currency($n) {
    return number_format($n, 2, ',', ' ');
}

// Génération du numéro de facture (exemple: 20250806111)
// Ici, nous utilisons la date et l'heure actuelles pour un numéro unique.
// Si vous avez un système d'ID de facture dans votre DB, vous pouvez l'utiliser.
$numero_facture = date('YmdHis'); // AnnéeMoisJourHeureMinuteSeconde

// Créer une instance de Dompdf
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

// Générer le contenu HTML de la facture dans une variable
ob_start();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Facture N°<?= htmlspecialchars($numero_facture) ?></title>
    <style>
        html { height: 100%; }
        body {
            font-family: sans-serif;
            margin: 0;
            padding: 0;
            font-size: 10px;
            padding-bottom: 10mm;
        }

        @page { margin: 1cm; }

        .logo-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 70mm;
            height: 25mm;
            z-index: 1;
        }
        .logo-container img {
            max-width: 90%;
            height: auto;
            display: block;
        }

        .first-page-header-box {
            position: absolute;
            top: 0;
            right: 0;
            height: 20mm;
            width: 50mm;
            text-align: center;
            border: 1px solid black;
            padding: 8px 12px;
            font-size: 1.2em;
            font-weight: bold;
            box-sizing: border-box;
            margin-top: 10px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 2;
        }
        .first-page-header-box p {
            margin: 2px 0;
            line-height: 1.4;
        }
        .first-page-header-box p:first-child {
            font-size: 1.3em;
            margin-bottom: 5px;
        }
        .document-container {
            width: 100%;
            position: relative;
            margin-top: 35mm;
        }

        .document-container:not(:first-of-type) {
            margin-top: 0;
        }

        .main-info-columns {
            display: table;
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10mm;
        }
        .main-info-columns .section {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding-right: 10mm;
        }

        .info-section-two-cols .info-line {
            display: table;
            width: 100%;
            margin-bottom: 3px;
        }
        .info-section-two-cols .info-line strong,
        .info-section-two-cols .info-line span {
            display: table-cell;
            vertical-align: top;
            font-size: 0.9em;
        }
        .info-section-two-cols .info-line strong {
            width: 30%;
            font-weight: bold;
        }
        .info-section-two-cols .info-line span {
            width: 70%;
        }
        
        .client-info, .period-info {
            font-size: 1.2em;
            text-align: left;
            margin-bottom: 10px;
        }
        .client-info strong, .period-info strong {
            display: inline-block;
            /* width: 100px;  Ajustez selon besoin */
            margin-right: 5px; /* Ajout d'une petite marge pour la séparation */
        }
        .client-info p, .period-info p {
            margin: 2px 0;
            display: flex; /* Utilisation de flexbox pour l'alignement étiquette-valeur */
            align-items: baseline;
        }
        .client-info p strong, .period-info p strong {
            flex-shrink: 0; /* Empêche l'étiquette de rétrécir */
            min-width: 80px; /* Largeur minimale pour les étiquettes */
        }
        
        .observation-box {
            margin-top: 5mm;
            margin-bottom: 5mm;
            padding: 8px;
            border-radius: 4px;
            background-color: #f9f9f9;
        }
        .observation-box strong {
            font-size: 1.1em;
            display: block;
            margin-bottom: 3px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 2mm;
            margin-bottom: 5mm;
            table-layout: fixed;
        }
        th, td {
            border: 1px solid black;
            padding: 8px 6px;
            text-align: left;
            font-size: 0.9em;
            vertical-align: middle;
            word-wrap: break-word;
        }
        th {
            background-color: #e0e0e0;
            color: black;
            text-transform: uppercase;
            font-weight: bold;
            text-align: center;
        }
        /* Ajustement des largeurs de colonnes */
        th:nth-child(1), td:nth-child(1) { width: 5%; text-align: center; } /* # */
        th:nth-child(2), td:nth-child(2) { width: 15%; } /* Date Sortie */
        th:nth-child(3), td:nth-child(3) { width: 20%; } /* Véhicule */
        th:nth-child(4), td:nth-child(4) { width: 30%; } /* Désignation Pièce */
        th:nth-child(5), td:nth-child(5) { width: 10%; text-align: center; } /* Quantité */
        th:nth-child(6), td:nth-child(6) { width: 20%; text-align: center; } /* Prix U HT */
        /* Note: TVA et TOTAL TTC Ligne sont retirés comme demandé */
        
        thead { display: table-header-group; }

        .totals-summary-box {
            width: 30%;
            margin-left: auto;
            border: 1px solid black;
            padding: 5px;
            margin-top: 0mm;
            margin-bottom: 0mm;
            box-sizing: border-box;
            clear: both;
            page-break-inside: avoid;
        }

        .total-line {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2px;
            padding: 2px 0;
        }

        .total-line .total-label {
            font-weight: bold;
            text-align: left;
            font-size: 1.0em;
        }

        .total-line .total-value {
            text-align: right;
            font-size: 1.1em;
        }

        .final-total .total-label,
        .final-total .total-value {
            font-size: 1.2em;
            font-weight: bold;
            padding-top: 0px;
            margin-top: 0px;
        }
        
        #footer-content {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100%;
            text-align: center;
            font-size: 0.7em;
            color: black;
            border-top: 1px solid black;
            padding-top: 5px;
            box-sizing: border-box;
            line-height: 1.4;
        }
        #footer-content p {
            margin: 2px 0;
        }
    </style>
</head>
<body>
    <div class="logo-container">
        <?php if (!empty($logo_base64)): ?>
            <img src="<?= $logo_base64 ?>" alt="Logo ASE">
        <?php else: ?>
            <p style="color: red; font-size: 0.8em;">Logo non trouvé</p>
        <?php endif; ?>
    </div>

    <div class="first-page-header-box" style="text-align: center;">
        <p>FACTURE</p>
        <p>N°<?= htmlspecialchars($numero_facture) ?></p>
        <p><?= htmlspecialchars(date('d/m/Y')) ?></p>
    </div>

    <div class="document-container">
        <div class="main-info-columns">
            <div class="section client-info">
                <p><?= htmlspecialchars($client_nom) ?></p>
                <p><?= htmlspecialchars($client_contact) ?></p>
                <p><?= htmlspecialchars($client_nif) ?></p>
                <p><?= htmlspecialchars($client_stat) ?></p><br>
                <p><strong>Véhicule (Sigle) :</strong> <?= htmlspecialchars($filter_vehicule_sigle !== 'all' ? $filter_vehicule_sigle . (!empty($vehicule_immatriculation) ? ' (' . $vehicule_immatriculation . ')' : '') : 'Tous') ?></p>
            </div>
        </div>
        
        <?php if (empty($sorties_data)): ?>
            <p style="text-align: center;">Aucune sortie trouvée pour cette période et ce véhicule.</p>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date Sortie</th>
                            <th>Véhicule</th>
                            <th>Désignation Pièce</th>
                            <th>Quantité</th>
                            <th>Prix U HT</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $global_item_index = 0;
                        foreach ($sorties_data as $sortie):
                            foreach ($sortie['details_pieces'] as $item):
                                $global_item_index++;
                                $quantite = isset($item['quantite_sortie']) ? (float)$item['quantite_sortie'] : 0;
                                $prix_unitaire_ht = isset($item['prix_unitaire_ht_au_moment_sortie']) ? (float)$item['prix_unitaire_ht_au_moment_sortie'] : 0;
                                // $tva_pourcentage = isset($item['tva_taux_au_moment_sortie']) ? (float)$item['tva_taux_au_moment_sortie'] : 0; // Non utilisé dans le tableau
                                // $montant_ht_ligne = $quantite * $prix_unitaire_ht; // Non utilisé dans le tableau
                                // $montant_tva_ligne = $montant_ht_ligne * ($tva_pourcentage / 100); // Non utilisé dans le tableau
                                // $montant_ttc_ligne = $montant_ht_ligne + $montant_tva_ligne; // Non utilisé dans le tableau
                        ?>
                                <tr>
                                    <td><?= $global_item_index ?></td>
                                    <td><?= htmlspecialchars((new DateTime($sortie['date_sortie']))->format('d/m/Y')) ?></td>
                                    <td><?= htmlspecialchars($sortie['immatriculation'] . ' / ' . $sortie['sigle']) ?></td>
                                    <td><?= htmlspecialchars($item['nom_piece']); ?> (Réf: <?= htmlspecialchars($item['reference']); ?>)</td>
                                    <td style="text-align: center;"><?= format_currency($quantite); ?></td>
                                    <td style="text-align: center;"><?= format_currency($prix_unitaire_ht); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="totals-summary-box">
                <div class="total-line">
                    <span class="total-label">TOTAL HT:</span>
                    <span class="total-value"><?= format_currency($total_general_ht) ?> Ar</span>
                </div>
                <div class="total-line">
                    <span class="total-label">TOTAL TVA:</span>
                    <span class="total-value"><?= format_currency($total_general_tva) ?> Ar</span>
                </div>
                <div class="total-line final-total">
                    <span class="total-label"><strong>TOTAL TTC:</strong></span>
                    <span class="total-value"><strong><?= format_currency($total_general_ttc) ?> Ar</strong></span>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div id="footer-content">
        <p><strong><?= htmlspecialchars($nom_entreprise) ?></strong></p>
        <p>NIF: <?= htmlspecialchars($nif_entreprise); ?> - STAT: <?= htmlspecialchars($stat_entreprise); ?></p>
        <p><?= htmlspecialchars($adresse_entreprise); ?> - Tél: <?= htmlspecialchars($tel_entreprise); ?> - Email: <?= htmlspecialchars($email_entreprise); ?></p>
        <p>RIB BGFI: <?= htmlspecialchars($rib_bgfi); ?> - RIB BFV: <?= htmlspecialchars($rib_bfv); ?></p>
    </div>

</body>
</html>
<?php
$html = ob_get_clean();

$dompdf->loadHtml($html);

// Ajustez le deuxième paramètre si vous voulez des marges spécifiques.
// Pour des marges de 1cm de chaque côté, vous pouvez utiliser:
// $dompdf->setPaper('A4', 'portrait');
// Ou pour des marges nulles comme dans l'original du bon de commande:
$dompdf->setPaper('A4', 'portrait', array(0, 0, 0, 0));


$dompdf->render();

$filename = 'Facture_N' . $numero_facture . '.pdf';
$dompdf->stream($filename, ["Attachment" => true]);
exit();
?>
