<?php
// ASE_Maintenance/generate_carnet_pdf.php

session_start();

// Pour le débogage :
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

require_once 'php/config.php';

// Inclusion de la bibliothèque Dompdf
require_once 'dompdf-3.1.0/dompdf/vendor/autoload.php';
use Dompdf\Dompdf;
use Dompdf\Options;

// Définit le fuseau horaire à Antananarivo, Madagascar
date_default_timezone_set('Indian/Antananarivo');

// Vérification de l'authentification et du rôle Administrateur ou Magasinier
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || ($_SESSION['role'] !== 'Administrateur' && $_SESSION['role'] !== 'Magasinier')) {
    header('Location: index.php'); // Rediriger si non autorisé
    exit();
}

$pdo = getDbConnection();

// Récupération des filtres depuis l'URL
$filter_vehicule_sigle = trim($_GET['filter_vehicule_sigle'] ?? 'all');
$filter_start_date = trim($_GET['filter_start_date'] ?? '');
$filter_end_date = trim($_GET['filter_end_date'] ?? '');

$sql_where = " WHERE 1=1 ";
$params = [];

// Filtrage par sigle du véhicule
if (!empty($filter_vehicule_sigle) && $filter_vehicule_sigle !== 'all') {
    $sql_where .= " AND v.sigle = ?";
    $params[] = $filter_vehicule_sigle;
}

// Filtrage par intervalle de dates si spécifié
if (!empty($filter_start_date)) {
    $sql_where .= " AND i.date_intervention >= ?";
    $params[] = $filter_start_date;
}
if (!empty($filter_end_date)) {
    $sql_where .= " AND i.date_intervention <= ?";
    $params[] = $filter_end_date;
}

// Récupération des données pour le carnet d'entretien (toutes les données sans pagination)
$stmt_carnet = $pdo->prepare("
    SELECT
        i.id_intervention,
        i.date_intervention,
        i.kilometrage_intervention,
        i.origine_panne,
        i.rapport_intervention,
        v.immatriculation,
        v.sigle,
        v.marque,
        cli.nom_client,
        GROUP_CONCAT(DISTINCT CONCAT(p.nom_piece, ' (', dsp.quantite_sortie, 'x ', dsp.prix_unitaire_ht_au_moment_sortie, ' Ar HT)') SEPARATOR ' ; ') AS details_pieces_resume
    FROM
        interventions i
    JOIN vehicules v ON i.id_vehicule = v.id_vehicule
    LEFT JOIN clients cli ON i.id_client = cli.id_client
    LEFT JOIN sorties_pieces sp ON i.id_intervention = sp.id_intervention
    LEFT JOIN details_sortie_piece dsp ON sp.id_sortie = dsp.id_sortie
    LEFT JOIN piece p ON dsp.id_piece = p.id_piece
    " . $sql_where . "
    GROUP BY i.id_intervention
    ORDER BY i.date_intervention DESC
");
$stmt_carnet->execute($params);
$carnet_data = $stmt_carnet->fetchAll(PDO::FETCH_ASSOC);

// Préparer le logo en Base64 pour Dompdf
$logo_path = 'img/logo_ase.png';
$logo_base64 = '';
if (file_exists($logo_path)) {
    $type = pathinfo($logo_path, PATHINFO_EXTENSION);
    $data = file_get_contents($logo_path);
    $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
}

// Créer une instance de Dompdf
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

ob_start();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Carnet d'Entretien Véhicule</title>
    <style>
        html { height: 100%; }
        body {
            font-family: sans-serif;
            margin: 0;
            padding: 0;
            font-size: 10px;
            padding-bottom: 10mm;
        }

        @page { margin: 1cm; }

        .logo-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 70mm;
            height: 25mm;
            z-index: 1;
        }
        .logo-container img {
            max-width: 90%;
            height: auto;
            display: block;
        }

        .first-page-header-box {
            position: absolute;
            top: 0;
            right: 0;
            height: 20mm;
            width: 50mm;
            text-align: center;
            border: 1px solid black;
            padding: 8px 12px;
            font-size: 1.2em;
            font-weight: bold;
            box-sizing: border-box;
            margin-top: 10px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 2;
        }
        .first-page-header-box p {
            margin: 2px 0;
            line-height: 1.4;
        }
        .first-page-header-box p:first-child {
            font-size: 1.3em;
            margin-bottom: 5px;
        }
        .document-container {
            width: 100%;
            position: relative;
            margin-top: 35mm;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 2mm;
            margin-bottom: 5mm;
            table-layout: fixed;
        }
        th, td {
            border: 1px solid black;
            padding: 8px 6px;
            text-align: left;
            font-size: 0.9em;
            vertical-align: top;
            word-wrap: break-word;
        }
        th {
            background-color: #e0e0e0;
            color: black;
            text-transform: uppercase;
            font-weight: bold;
            text-align: center;
        }
        thead { display: table-header-group; }

        .report-summary-box {
            margin-bottom: 10mm;
        }
        .report-summary-box strong {
            display: block;
            margin-bottom: 2mm;
        }
        .report-summary-box p {
            margin: 2px 0;
        }
        .text-info {
            width: 100%;
            display: table;
            margin-bottom: 5mm;
        }
        .text-info div {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }
        .no-data {
            text-align: center;
            margin-top: 20px;
            font-size: 1.2em;
        }
        
        #footer-content {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100%;
            text-align: center;
            font-size: 0.7em;
            color: black;
            border-top: 1px solid black;
            padding-top: 5px;
            box-sizing: border-box;
            line-height: 1.4;
        }
        #footer-content p {
            margin: 2px 0;
        }
    </style>
</head>
<body>
    <div class="logo-container">
        <?php if (!empty($logo_base64)): ?>
            <img src="<?= $logo_base64 ?>" alt="Logo ASE">
        <?php else: ?>
            <p style="color: red; font-size: 0.8em;">Logo non trouvé</p>
        <?php endif; ?>
    </div>

    <div class="first-page-header-box">
        <p>CARNET D'ENTRETIEN</p>
        <p>Généré le <?= date('d/m/Y') ?></p>
    </div>

    <div class="document-container">
        <div class="text-info">
            <div>
                <p><strong>Généré par :</strong> <?php echo htmlspecialchars($_SESSION['username'] ?? 'N/A'); ?> (<?php echo htmlspecialchars($_SESSION['role'] ?? 'N/A'); ?>)</p>
                <p><strong>Date de génération :</strong> <?php echo date('d/m/Y H:i:s'); ?></p>
            </div>
        </div>

        <?php if (empty($carnet_data)): ?>
            <p class="no-data">Aucune intervention trouvée pour cette période et ce véhicule.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Date Interv.</th>
                        <th>Véhicule (Immatriculation / Sigle)</th>
                        <th>Client</th>
                        <th>Kilométrage</th>
                        <th>Origine Panne</th>
                        <th>Rapport Interv.</th>
                        <th>Pièces Utilisées</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($carnet_data as $intervention):
                    ?>
                        <tr>
                            <td><?php echo date('d/m/Y', strtotime($intervention['date_intervention'])); ?></td>
                            <td><?php echo htmlspecialchars($intervention['immatriculation'] . ' (' . $intervention['sigle'] . ')'); ?></td>
                            <td><?php echo htmlspecialchars($intervention['nom_client'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($intervention['kilometrage_intervention'] ?? 'N/A'); ?> km</td>
                            <td><?php echo htmlspecialchars($intervention['origine_panne'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($intervention['rapport_intervention'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($intervention['details_pieces_resume'] ?? 'Aucune'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

    <div id="footer-content">
        <p><strong>AUTO SERVICE DE L'EST SARL</strong></p>
        <p>NIF: 3002015172 - STAT: 77100312000183</p>
        <p>Rue de commerce Toamasina 501 - Tél: +261 34 05 216 90 - Email: contact@ase.mg</p>
        <p>RIB BGFI: 00012 01250 41015401011 63 - RIB BFV: 00008 00490 02001012003 70</p>
    </div>

</body>
</html>
<?php
$html = ob_get_clean();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$filename = "Carnet_Entretien_" . date('Ymd_His') . ".pdf";
$dompdf->stream($filename, ["Attachment" => true]);
exit();
?>