<?php
session_start();
require_once 'php/config.php';
require_once 'dompdf-3.1.0/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

date_default_timezone_set('Indian/Antananarivo');

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || $_SESSION['role'] !== 'Magasinier') {
    header('Location: index.php');
    exit();
}

if (!isset($_GET['id_montage'])) {
    die("ID montage manquant");
}

$id_montage = (int) $_GET['id_montage'];
$pdo = getDbConnection();

// 1️⃣ Trouver l'id_sortie_pneu correspondant à ce montage
$sql_id_sortie = "
    SELECT s.id_sortie_pneu
    FROM montage_pneu_vehicule m
    JOIN inventaire_pneu inv ON m.id_inventaire_pneu = inv.id_inventaire_pneu
    JOIN details_sortie_pneu ds ON inv.id_inventaire_pneu = ds.id_inventaire_pneu
    JOIN sorties_pneu s ON ds.id_sortie_pneu = s.id_sortie_pneu
    WHERE m.id_montage = ?
    ORDER BY s.date_sortie DESC
    LIMIT 1
";
$stmt = $pdo->prepare($sql_id_sortie);
$stmt->execute([$id_montage]);
$id_sortie = $stmt->fetchColumn();

if (!$id_sortie) {
    die("Aucune sortie trouvée pour ce montage");
}

// 2️⃣ Récupérer les infos de la sortie + prix unitaire TTC
$sql_sortie = "
    SELECT
        s.id_sortie_pneu,
        s.date_sortie,
        s.raison_sortie,
        u.nom_utilisateur AS nom_magasinier,
        inv.numero_serie,
        p.nom_modele,
        m.nom_marque,
        d.valeur_dimension,
        pr.nom_profil,
        inv.statut_pneu AS statut_final_pneu,
        inv.emplacement_actuel,
        inv.kilometrage_total_pneu,
        inv.profondeur_gomme_mm,
        ROUND(p.prix_achat_ht * (1 + p.tva_applicable / 100), 2) AS prix_unitaire_ttc,
        COALESCE(
            (SELECT mont.kilometrage_demontage
             FROM montage_pneu_vehicule mont
             WHERE mont.id_inventaire_pneu = inv.id_inventaire_pneu
             AND DATE(mont.date_demontage) = DATE(s.date_sortie)
             ORDER BY mont.date_demontage DESC LIMIT 1),
            0
        ) AS kilometrage_au_demontage_sortie
    FROM sorties_pneu s
    JOIN details_sortie_pneu ds ON s.id_sortie_pneu = ds.id_sortie_pneu
    JOIN inventaire_pneu inv ON ds.id_inventaire_pneu = inv.id_inventaire_pneu
    JOIN pneus p ON inv.id_pneu = p.id_pneu
    JOIN marques_pneu m ON p.id_marque = m.id_marque
    JOIN dimensions_pneu d ON p.id_dimension = d.id_dimension
    JOIN profils_pneu pr ON p.id_profil = pr.id_profil
    JOIN utilisateurs u ON s.id_magasinier = u.id_utilisateur
    WHERE s.id_sortie_pneu = ?
";

$stmt = $pdo->prepare($sql_sortie);
$stmt->execute([$id_sortie]);
$sortie_data = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$sortie_data) {
    die("Données de sortie introuvables");
}

// 3️⃣ Calcul du total TTC
$total_ttc = 0;
foreach ($sortie_data as $item) {
    $total_ttc += (float) $item['prix_unitaire_ttc'];
}

// 3️⃣ bis — Numéro unique de bon de sortie
$numero_bon_sortie = 'BS-' . date('Ymd') . '-' . rand(1000, 9999);

// 4️⃣ Infos fixes entreprise
$nom_entreprise = "AUTO SERVICE DE L'EST SARL";
$adresse_entreprise = "Rue de commerce Toamasina 501";
$nif_entreprise = "3002015172";
$stat_entreprise = "77100312000183";
$tel_entreprise = "+261 34 05 216 90";
$email_entreprise = "contact@ase.mg";
$rib_bgfi = "00012 01250 41015401011 63";
$rib_bfv = "00008 00490 02001012003 70";

// 5️⃣ Logo
$logo_path = 'img/logo_ase.png';
$logo_base64 = '';
if (file_exists($logo_path)) {
    $type = pathinfo($logo_path, PATHINFO_EXTENSION);
    $data = file_get_contents($logo_path);
    $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
}

// 6️⃣ PDF
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

ob_start();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Bon de Sortie Pneu</title>
<style>
    html { height: 100%; }
    body {
        font-family: sans-serif;
        margin: 0;
        padding: 0;
        font-size: 10px;
        padding-bottom: 10mm;
    }
    @page { margin: 1cm; }
    .logo-container {
        position: absolute;
        top: 0;
        left: 0;
        width: 70mm;
        height: 25mm;
        z-index: 1;
    }
    .logo-container img {
        max-width: 90%;
        height: auto;
        display: block;
    }
    .first-page-header-box {
        position: absolute;
        top: 0;
        right: 0;
        height: 25mm;
        width: 55mm;
        text-align: center;
        border: 1px solid black;
        padding: 6px 8px;
        font-size: 1.2em;
        font-weight: bold;
        box-sizing: border-box;
        margin-top: 10px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        z-index: 2;
    }
    .first-page-header-box p {
        margin: 2px 0;
        line-height: 1.4;
    }
    .first-page-header-box p:first-child {
        font-size: 1.3em;
        margin-bottom: 5px;
    }
    .document-container {
        width: 100%;
        position: relative;
        margin-top: 35mm;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 2mm;
        margin-bottom: 5mm;
    }
    th, td {
        border: 1px solid black;
        padding: 8px 6px;
        text-align: left;
        font-size: 0.9em;
        vertical-align: top;
        word-wrap: break-word;
    }
    th {
        background-color: #e0e0e0;
        color: black;
        text-transform: uppercase;
        font-weight: bold;
        text-align: center;
    }
    thead { display: table-header-group; }
    .total-box {
        width: 40%; float: right; margin-top: 10px;
        border: 1px solid black; border-collapse: collapse;
    }
    .total-box th, .total-box td {
        border: 1px solid black; padding: 6px; font-size: 1em;
    }
    .bon-sortie-header {
        margin-bottom: 15px;
        border-bottom: 1px solid #ccc;
        padding-bottom: 10px;
        page-break-after: avoid;
    }
    .bon-sortie-header h2 {
        margin: 0;
        font-size: 1.2em;
    }
    .bon-sortie-header p {
        margin: 2px 0;
        font-size: 0.9em;
    }
   
    #footer-content {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        width: 100%;
        text-align: center;
        font-size: 0.7em;
        color: black;
        margin-left: 120px;
        padding: 5px 10px;
        box-sizing: border-box;
        background-color: #fff;
    }
</style>
</head>
<body>
<div class="logo-container">
    <?php if (!empty($logo_base64)): ?>
        <img src="<?= $logo_base64 ?>" alt="Logo ASE">
    <?php endif; ?>
</div>

<div class="first-page-header-box">
    <p>BON DE SORTIE</p>
    <p>Pneus</p>
    <p style="font-size:0.8em; margin-top:5px;">N° <?= htmlspecialchars($numero_bon_sortie) ?></p>
</div>

<div class="document-container">
    <div class="bon-sortie-header">
        <h2>Bon de Sortie #<?= htmlspecialchars($sortie_data[0]['id_sortie_pneu']) ?></h2>
        <p><strong>Date de sortie :</strong> <?= date('d/m/Y H:i', strtotime($sortie_data[0]['date_sortie'])) ?></p>
        <p><strong>Raison :</strong> <?= htmlspecialchars($sortie_data[0]['raison_sortie']) ?></p>
        <p><strong>Magasinier :</strong> <?= htmlspecialchars($sortie_data[0]['nom_magasinier']) ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>N° Série</th>
                <th>Modèle</th>
                <th>Prix unitaire TTC</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($sortie_data as $item): ?>
            <tr>
                <td><?= htmlspecialchars($item['numero_serie']) ?></td>
                <td><?= htmlspecialchars($item['nom_modele'] . ' (' . $item['nom_marque'] . ' - ' . $item['valeur_dimension'] . ')') ?></td>
                <td style="text-align:right;"><?= number_format($item['prix_unitaire_ttc'], 2, ',', ' ') ?> Ar</td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Encadré Total TTC -->
    <table class="total-box">
        <tr>
            <th>TOTAL TTC</th>
            <td style="text-align:right;"><?= number_format($total_ttc, 2, ',', ' ') ?> Ar</td>
        </tr>
    </table>
</div>

<div id="footer-content">
    <hr style="margin-left: -180px;">
    <p><strong><?= htmlspecialchars($nom_entreprise) ?></strong></p>
    <p>NIF: <?= htmlspecialchars($nif_entreprise); ?> - STAT: <?= htmlspecialchars($stat_entreprise); ?></p>
    <p><?= htmlspecialchars($adresse_entreprise); ?> - Tél: <?= htmlspecialchars($tel_entreprise); ?> - Email: <?= htmlspecialchars($email_entreprise); ?></p>
    <p>RIB BGFI: <?= htmlspecialchars($rib_bgfi); ?> - RIB BFV: <?= htmlspecialchars($rib_bfv); ?></p>
</div>

</body>
</html>
<?php
$html = ob_get_clean();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$filename = "Bon_de_Sortie_Pneu_" . date('Ymd_His') . ".pdf";
$dompdf->stream($filename, ["Attachment" => true]);
exit();
?>
