<?php
// ASE_Maintenance/details_sorties_globales.php
ob_start();

session_start();
require_once 'php/config.php';
// Définit le fuseau horaire à Antananarivo, Madagascar
date_default_timezone_set('Indian/Antananarivo');
if (
    !isset($_SESSION['loggedin']) 
    || $_SESSION['loggedin'] !== true 
    || !isset($_SESSION['role']) 
    || $_SESSION['role'] !== 'Administrateur'
) {
    header('Location: index');
    exit();
}


$pdo = getDbConnection();

$message = '';
$message_type = '';

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message']);
    unset($_SESSION['message_type']);
}

$records_per_page = 5; // Nombre d'enregistrements par page (5 lignes par tableau)

// Fonction pour construire la clause WHERE et les paramètres pour les filtres
function buildFilterClause($filter_vehicule_sigle, $filter_start_date, $filter_end_date, $filter_id_client) {
    $sql_where = " WHERE 1=1 ";
    $params = [];

    // Filtrage par sigle du véhicule
    if (!empty($filter_vehicule_sigle) && $filter_vehicule_sigle !== 'all') {
        $sql_where .= " AND v.sigle = ?";
        $params[] = $filter_vehicule_sigle;
    }

    // Filtrage par client
    if (!empty($filter_id_client) && $filter_id_client !== 'all') {
        $sql_where .= " AND cli.id_client = ?";
        $params[] = $filter_id_client;
    }

    // Filtrage par intervalle de dates si spécifié
    if (!empty($filter_start_date)) {
        $sql_where .= " AND sp.date_sortie >= ?";
        $params[] = $filter_start_date;
    }
    if (!empty($filter_end_date)) {
        $sql_where .= " AND sp.date_sortie <= ?";
        $params[] = $filter_end_date;
    }

    return ['sql_where' => $sql_where, 'params' => $params];
}

// --- Endpoint AJAX pour récupérer les données filtrées des sorties (factures) ---
if (isset($_GET['action']) && $_GET['action'] === 'get_filtered_sorties_data') {
    // Nettoie toute sortie tamponnée avant d'envoyer l'en-tête et le contenu JSON
    ob_clean();
    header('Content-Type: application/json');

    $current_page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
    $filter_vehicule_sigle = trim($_GET['filter_vehicule_sigle'] ?? '');
    $filter_start_date = trim($_GET['filter_start_date'] ?? '');
    $filter_end_date = trim($_GET['filter_end_date'] ?? '');
    $filter_id_client = trim($_GET['filter_id_client'] ?? ''); // Récupération du nouveau filtre client

    $offset = ($current_page - 1) * $records_per_page;

    $filter_data = buildFilterClause($filter_vehicule_sigle, $filter_start_date, $filter_end_date, $filter_id_client);
    $sql_where = $filter_data['sql_where'];
    $params = $filter_data['params'];

    try {
        // Pour le comptage total
        $stmt_total = $pdo->prepare("
            SELECT COUNT(DISTINCT sp.id_sortie)
            FROM sorties_pieces sp
            JOIN interventions i ON sp.id_intervention = i.id_intervention
            JOIN vehicules v ON i.id_vehicule = v.id_vehicule
            LEFT JOIN clients cli ON i.id_client = cli.id_client
            " . $sql_where
        );
        $stmt_total->execute($params);
        $total_records = $stmt_total->fetchColumn();
        $total_pages = ceil($total_records / $records_per_page);

        // Récupération des données des sorties de pièces
        $stmt_sorties = $pdo->prepare("
            SELECT
                sp.id_sortie,
                sp.date_sortie,
                sp.total_ttc,
                i.id_intervention,
                i.date_intervention,
                v.immatriculation,
                v.sigle,
                cli.nom_client,
                GROUP_CONCAT(CONCAT(p.nom_piece, ' (', dsp.quantite_sortie, 'x ', dsp.prix_unitaire_ht_au_moment_sortie, ' Ar HT)') SEPARATOR ' ; ') AS details_pieces_resume
            FROM
                sorties_pieces sp
            JOIN interventions i ON sp.id_intervention = i.id_intervention
            JOIN vehicules v ON i.id_vehicule = v.id_vehicule
            LEFT JOIN clients cli ON i.id_client = cli.id_client
            LEFT JOIN details_sortie_piece dsp ON sp.id_sortie = dsp.id_sortie
            LEFT JOIN piece p ON dsp.id_piece = p.id_piece
            " . $sql_where . "
            GROUP BY sp.id_sortie
            ORDER BY sp.date_sortie DESC
            LIMIT ? OFFSET ?
        ");
        $params_data = $params;
        $params_data[] = $records_per_page; 
        $params_data[] = $offset;
        $stmt_sorties->execute($params_data);
        $sorties_data = $stmt_sorties->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            'success' => true,
            'data' => $sorties_data,
            'current_page' => $current_page,
            'total_pages' => $total_pages,
            'total_records' => $total_records
        ]);

    } catch (PDOException $e) {
        error_log("Erreur PDO lors du chargement des sorties globales: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erreur de base de données lors du chargement des données : ' . $e->getMessage()]);
    }
    exit();
}

// --- Endpoint AJAX pour récupérer les données agrégées pour le graphique ---
if (isset($_GET['action']) && $_GET['action'] === 'get_chart_data') {
    // Nettoie toute sortie tamponnée avant d'envoyer l'en-tête et le contenu JSON
    ob_clean();
    header('Content-Type: application/json');

    $filter_vehicule_sigle = trim($_GET['filter_vehicule_sigle'] ?? '');
    $filter_start_date = trim($_GET['filter_start_date'] ?? '');
    $filter_end_date = trim($_GET['filter_end_date'] ?? '');
    $filter_id_client = trim($_GET['filter_id_client'] ?? ''); // Récupération du nouveau filtre client

    $filter_data = buildFilterClause($filter_vehicule_sigle, $filter_start_date, $filter_end_date, $filter_id_client);
    $sql_where = $filter_data['sql_where'];
    $params = $filter_data['params'];

    try {
        // Modification de la requête pour regrouper par sigle de véhicule
        $stmt_chart_data = $pdo->prepare("
            SELECT
                v.sigle AS vehicule_sigle,
                SUM(sp.total_ht)   AS total_ht_par_sigle,
                SUM(sp.total_ttc)  AS total_ttc_par_sigle
            FROM
                sorties_pieces sp
            JOIN interventions i ON sp.id_intervention = i.id_intervention
            JOIN vehicules v ON i.id_vehicule = v.id_vehicule
            LEFT JOIN clients cli ON i.id_client = cli.id_client
            " . $sql_where . "
            GROUP BY v.sigle
            ORDER BY v.sigle ASC
        ");

        $stmt_chart_data->execute($params);
        $chart_data = $stmt_chart_data->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode(['success' => true, 'data' => $chart_data]);

    } catch (PDOException $e) {
        error_log("Erreur PDO lors du chargement des données du graphique: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erreur de base de données lors du chargement des données du graphique : ' . $e->getMessage()]);
    }
    exit();
}

// Récupération de tous les sigles de véhicules pour le filtre (pour l'affichage initial)
try {
    $stmt_vehicule_sigles = $pdo->query("SELECT DISTINCT sigle FROM vehicules WHERE sigle IS NOT NULL ORDER BY sigle ASC");
    $vehicule_sigles = $stmt_vehicule_sigles->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $vehicule_sigles = [];
    $message = "Erreur lors du chargement des sigles de véhicules : " . $e->getMessage();
    $message_type = "error";
}

// Récupération de tous les clients pour le filtre (pour l'affichage initial)
try {
    $stmt_clients = $pdo->query("SELECT id_client, nom_client FROM clients ORDER BY nom_client ASC");
    $clients = $stmt_clients->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $clients = [];
    $message = "Erreur lors du chargement des clients : " . $e->getMessage();
    $message_type = "error";
}

// Termine la mise en mémoire tampon de sortie et envoie tout le contenu HTML
ob_end_flush();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Détails Sorties Globales - ASE Maintenance</title>
    <link rel="icon" type="image/png" href="img/logo_ase.png">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        /* [VOS STYLES CSS RESTENT INCHANGÉS ICI] */
/* Thème clair dégradé — aligné sur le tableau de bord */
:root {
  /* Fond et couleurs */
  --gradient-bg: linear-gradient(135deg, #ffffff 65%, #2ecc71 100%);
  --text-color: #222;
  --heading-color: #002147;
  --accent-color: #2ecc71;

  /* Bordures et surfaces */
  --border-color: rgba(0, 0, 0, 0.1);
  --input-bg: rgba(255, 255, 255, 0.85);
  --input-border: #ccc;
  --table-header-bg: #002147;
  --table-row-even-bg: rgba(0, 0, 0, 0.03);

  /* Boutons */
  --btn-primary-bg: #2563eb;
  --btn-primary-hover: #1d4ed8;
  --btn-success-bg: #16a34a;
  --btn-success-hover: #15803d;
  --btn-danger-bg: #dc2626;
  --btn-danger-hover: #b91c1c;
  --btn-info-bg: #0891b2;
  --btn-info-hover: #0e7490;

  /* États */
  --success-bg: rgba(22, 163, 74, 0.12);
  --success-text: #166534;
  --error-bg: rgba(220, 38, 38, 0.12);
  --error-text: #991b1b;
  --warning-bg: rgba(234, 179, 8, 0.12);
  --warning-text: #92400e;

  --form-gap: 12px;
  --form-field-padding: 10px;
}

/* Base */
body {
  margin: 0;
  font-family: 'Inter', sans-serif;
  background: var(--gradient-bg);
  background-attachment: fixed;
  color: var(--text-color);
  font-size: 15px;
  min-height: 100vh;
  overflow-x: hidden;
  display: flex;
  flex-direction: column;
}

/* Désactiver les sparkles pour coller au tableau de bord */
.sparkles-container { display: none; }

/* Navbar (même logique que le dashboard) */
/* Navbar avec gradient */
/* Navbar avec gradient */
.navbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: var(--gradient-bg);
    backdrop-filter: blur(8px);
    padding: 15px 30px;
    position: sticky;
    top: 0;
    z-index: 10;
}

.navbar img { height: 45px; }
.navbar-nav { list-style: none; display: flex; gap: 24px; }
.navbar-nav a {
    color: var(--heading-color);
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 500;
}
.navbar-nav a:hover, .navbar-nav a.active { color: var(--accent-color); }

.main-content {
  flex-grow: 1;
  background: var(--gradient-bg);
  backdrop-filter: blur(6px);
  color: var(--text-color);
  max-width: 1400px; width: 95%;
  margin: 30px auto; padding: 30px;
  border-radius: 10px;
  box-shadow: 0 8px 20px rgba(0,0,0,0.06);
}

/* Titres */
h1 {
  color: var(--heading-color);
  text-align: center;
  margin-bottom: 24px;
  font-size: 2.4em;
  /* border-bottom: 2px solid var(--border-color); */
  padding-bottom: 12px;
  letter-spacing: .5px;
}
h2.section-title, h3.section-title {
  color: var(--heading-color);
  /* border-bottom: 1px solid var(--border-color); */
  padding-bottom: 8px; margin: 18px 0 14px;
}
h2.section-title { font-size: 1.4em; }
h3.section-title { font-size: 1.2em; }

/* Sections cartes */
.form-section, .list-section {
  background: var(--gradient-bg);
  border-radius: 10px;
  padding: 20px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.05);
  /* border: 1px solid var(--border-color); */
  color: #000;
}

/* Messages (alertes) */
.message {
  padding: 12px 14px; margin-bottom: 16px; border-radius: 8px;
  font-weight: 600; font-size: .95em; display: flex; align-items: center; gap: 10px;
  border: 1px solid var(--border-color); box-shadow: 0 2px 5px rgba(0,0,0,0.03);
}
.message.success { background: var(--success-bg); color: var(--success-text); border-color: rgba(22, 101, 52, .25); }
.message.error { background: var(--error-bg); color: var(--error-text); border-color: rgba(153, 27, 27, .25); }
.message.warning { background: var(--warning-bg); color: var(--warning-text); border-color: rgba(146, 64, 14, .25); }

/* Conteneur des filtres : forcer l'alignement horizontal */
.form-section .flex {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
    align-items: flex-end; /* aligne les boutons sur la ligne des champs */
}

/* Uniformiser les champs de formulaire */
.form-group select,
.form-group input[type="date"],
.form-group input[type="text"] {
    background: #ffffff;            /* fond blanc */
    color: #222;                    /* texte sombre */
    border: 1px solid #ccc;
    border-radius: 6px;
    padding: 8px 10px;
    font-size: .95em;
}

/* Style des labels */
.form-group label {
    font-weight: 600;
    color: var(--heading-color, #002147);
}

/* Boutons */
.btn {
    color: #000 !important; /* texte noir */
    border: none;
    border-radius: 6px;
    font-weight: bold;
    padding: 8px 14px;
}

.btn-primary {
    background-color: #2563eb;
}
.btn-primary:hover {
    background-color: #1d4ed8;
}
.btn-success {
    background-color: #22c55e;
}
.btn-success:hover {
    background-color: #16a34a;
}
.btn-excel {
    background-color: #10B981; /* Vert émeraude */
}
.btn-excel:hover {
    background-color: #059669;
}


/* Tableaux */
.table-responsive {
  overflow: auto;
  /* border: 1px solid var(--border-color); */
  border-radius: 10px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}
table {
  width: 100%; border-collapse: collapse; min-width: 800px; background: transparent;
}
th, td {
  border-bottom: 1px solid var(--input-border);
  padding: 10px; text-align: left; font-size: .9rem; color: #000; vertical-align: middle;
}
th {
  background: rgba(0,33,71,0.95); color: #fff; text-transform: uppercase; font-size: .8rem; letter-spacing: .03em; position: sticky; top: 0; z-index: 1;
}
tr:nth-child(even) { background: var(--table-row-even-bg); }
tr:hover { background: rgba(46, 204, 113, 0.08); transition: background-color .15s; }
.table-actions { display: flex; gap: 8px; justify-content: center; align-items: center; }

/* Pagination */
.pagination {
  display: flex; gap: 8px; justify-content: center; align-items: center; margin-top: 14px; flex-wrap: wrap;
}
.pagination a, .pagination span {
  background: white;
  border: 1px solid var(--input-border);
  color: var(--text-color);
  padding: 8px 12px;
  border-radius: 8px;
  text-decoration: none; font-weight: 600; font-size: .95em;
}
.pagination a:hover { background: var(--accent-color); color: #00b947ff; border-color: transparent; }
.pagination .current-page { background: var(--accent-color); color: #f9f8f8ff; border-color: transparent; }
.pagination .disabled { opacity: .5; cursor: not-allowed; }

/* Modales */
.modal1 {
  display: none; position: fixed; inset: 0;
  background-color: rgba(0,0,0,0.6);
  z-index: 1000; justify-content: center; align-items: center;
  animation: fadeIn .25s forwards;
}
.modal1-content {
  background: var(--input-bg);
  margin: auto; padding: 20px 24px;
  border: 1px solid var(--input-border);
  border-radius: 12px; width: 95%; max-width: 720px;
  box-shadow: 0 10px 24px rgba(0,0,0,0.12);
  position: relative; transform: scale(.98);
  animation: slideIn .25s forwards;
  color: #000;
}
.modal1.open { display: flex; }
.modal1.open .modal1-content { transform: scale(1); }
.close1-button {
  color: var(--heading-color);
  position: absolute; top: 12px; right: 18px;
  font-size: 24px; font-weight: 700; cursor: pointer; transition: color .2s, transform .2s;
}
.close1-button:hover { color: var(--accent-color); transform: rotate(90deg); }

/* Animations modales */
@keyframes fadeIn { from {opacity: 0;} to {opacity: 1;} }
@keyframes slideIn { from {transform: translateY(-12px) scale(.98);} to {transform: translateY(0) scale(1);} }

/* Responsive */
@media (max-width: 1024px) {
  .main-content { max-width: 96%; padding: 24px; }
  table { min-width: 100%; }
}
@media (max-width: 768px) {
  .navbar-nav { display: none; }
  .burger-menu { display: block; }
  .main-content { margin: 16px auto; padding: 18px; width: auto; }
  h1 { font-size: 1.8em; margin-bottom: 16px; }
  h2.section-title, h3.section-title { font-size: 1.1em; }
  .btn { width: 100%; justify-content: center; margin-bottom: 8px; padding: 9px 12px; font-size: .95em; }
  .pagination { gap: 6px; }
  .pagination a, .pagination span { padding: 7px 10px; font-size: .9em; }
  .dropdown > a { cursor: pointer; }
  .flex.flex-wrap.items-end.justify-between.mb-4.gap-4 { display: block; }
  .flex.flex-wrap.items-end.justify-content-between.mb-4.gap-4 > div {
    width: 100% !important; padding-left: 0 !important; padding-right: 0 !important;
  }
  .form-section, .list-section { padding: 14px; margin-bottom: 16px; }
}
@media (max-width: 480px) {
  .main-content { padding: 12px; margin: 10px auto; }
  .navbar { padding: 10px 14px; }
  .navbar-brand img { height: 34px; }
  .navbar-brand span { font-size: 1.1em; }
  .btn { font-size: .9em; padding: 8px 12px; }
}

    </style>
</head>
<body>
    <nav class="navbar">
        <div><img src="img/logo_ase.png" alt="Logo"></div>
        <ul class="navbar-nav">
            <li><a href="tableau_bord"><i class="fas fa-tachometer-alt"></i> Tableau de bord</a></li>
            <li><a class="active" href="details_sorties_globales"><i class="fas fa-gauge-high"></i> Admin legacy</a></li>
            <li><a href="rapports_analyses"><i class="fas fa-chart-pie"></i> Rapports</a></li>
            <li><a href="carnet_entretien_vehicule"><i class="fas fa-truck"></i> Flotte</a></li>
            <li><a href="rapport_pneumatique"><i class="fas fa-history"></i> Détails pneumatique</a></li>
            <li><a href="achats_effectues"><i class="fas fa-boxes-packing"></i> Achats effectués</a></li>
            <li><a href="sorties_effectuees"><i class="fas fa-truck-loading"></i> Sorties effectuées</a></li>
            <li><a href="php/authentification.php?action=logout"><i class="fa-solid fa-power-off"></i></a></li>
        </ul>
    </nav>

    <div class="sparkles-container"></div>

    <div class="main-content">
        <h1 id="page-title">Détails des Sorties Globales (Factures)</h1>

        <?php if ($message): ?>
            <div class="message <?php echo htmlspecialchars($message_type); ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <div class="form-section">
            <h2 class="section-title">Filtres de Facturation</h2>
            <div class="flex flex-wrap items-end justify-between mb-4 gap-4">
                <div class="form-group flex-grow mb-0">
                    <label for="filter_vehicule_sigle" style="background-color: white; color: black;">Filtrer par Sigle Véhicule:</label>
                    <select id="filter_vehicule_sigle" class="w-full" style="background-color: white; color: black;">
                        <option value="all">Tous les véhicules</option>
                        <?php foreach ($vehicule_sigles as $sigle): ?>
                            <option value="<?php echo htmlspecialchars($sigle['sigle']); ?>"><?php echo htmlspecialchars($sigle['sigle']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group flex-grow mb-0">
                    <label for="filter_id_client" style="background-color: white; color: black;">Filtrer par Client:</label>
                    <select id="filter_id_client" class="w-full" style="background-color: white; color: black;">
                        <option value="all">Tous les clients</option>
                        <?php foreach ($clients as $client): ?>
                            <option value="<?php echo htmlspecialchars($client['id_client']); ?>"><?php echo htmlspecialchars($client['nom_client']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group flex-grow mb-0">
                    <label for="filter_start_date" style="background-color: white; color: black;">Date de Début:</label>
                    <input type="date" id="filter_start_date" class="w-full">
                </div>
                <div class="form-group flex-grow mb-0">
                    <label for="filter_end_date" style="background-color: white; color: black;">Date de Fin:</label>
                    <input type="date" id="filter_end_date" class="w-full">
                </div>
                <div class="mb-0">
                    <button type="button" class="btn btn-primary btn-sm" id="apply_filters_sorties"><i class="fas fa-filter"></i> Appliquer les filtres</button>
                </div>
                <div class="mb-0">
                    <button type="button" class="btn btn-success btn-sm" id="generate_invoice_pdf_btn"><i class="fas fa-file-invoice"></i> Générer Facture PDF</button>
                </div>
                <div class="mb-0">
                    <button type="button" class="btn btn-excel btn-sm" id="generate_excel_btn"><i class="fas fa-file-excel"></i> Générer Excel</button>
                </div>
            </div>
        </div><br>

        <div class="list-section">
            <h2 class="section-title">Sorties Détaillées (Coût Total TTC)</h2>
            <div class="table-responsive">
                <table id="sortiesDetailsTable">
                    <thead>
                        <tr>
                            <th>ID Sortie</th>
                            <th>Date Sortie</th>
                            <th>ID Interv.</th>
                            <th>Véhicule (Sigle)</th>
                            <th>Client</th>
                            <th>Détails Pièces Résumé</th>
                            <th>Coût Total TTC</th>
                        </tr>
                    </thead>
                    <tbody id="sortiesDetailsTableBody">
                        </tbody>
                </table>
            </div>
            <div class="pagination" id="sortiesDetailsPagination">
                </div>
        </div>

        <div class="list-section mt-8">
            <h2 class="section-title">Graphique des Sorties par Sigle Véhicule (Coût Total TTC)</h2>
            <div class="chart-container" style="position: relative; height:400px; width:100%;">
                <canvas id="salesChart"></canvas>
                <div id="noChartDataMessage" class="absolute inset-0 flex items-center justify-center text-gray-500 hidden">
                    Aucune donnée disponible pour le graphique avec les filtres actuels.
                </div>
            </div>
        </div>
    </div>
<?php include('message.php'); ?>
    <script>
        // [LE RESTE DU JAVASCRIPT RESTE INCHANGÉ JUSQU'À L'ÉVÉNEMENT DOMContentLoaded]

        // Fonction globale pour afficher les messages (réutilisée)
        function showMessage(msg, type) {
            const mainContent = document.querySelector('.main-content');
            let messageDiv = document.querySelector('.dynamic-message');

            if (messageDiv) {
                messageDiv.remove();
            }

            messageDiv = document.createElement('div');
            messageDiv.classList.add('message', 'dynamic-message', type);
            messageDiv.innerHTML = `<i class="fas ${type === 'success' ? 'fa-check-circle' : (type === 'error' ? 'fa-times-circle' : 'fa-info-circle')}"></i> ${msg}`;

            const pageTitle = document.getElementById('page-title');
            if (pageTitle && mainContent) {
                 mainContent.insertBefore(messageDiv, pageTitle.nextSibling);
            } else if (mainContent) {
                mainContent.prepend(messageDiv);
            }

            setTimeout(() => {
                if (messageDiv) {
                    messageDiv.style.opacity = '0';
                    messageDiv.style.transition = 'opacity 0.5s ease-out';
                    setTimeout(() => messageDiv.remove(), 500);
                }
            }, 5000);
        }

        // Fonction pour générer les liens de pagination (réutilisée)
        function generatePagination(container, currentPage, totalPages, loadFunction) {
            container.innerHTML = '';
            if (totalPages <= 1) return;

            const maxPagesToShow = 5;
            let startPage = Math.max(1, currentPage - Math.floor(maxPagesToShow / 2));
            let endPage = Math.min(totalPages, startPage + maxPagesToShow - 1);

            if (endPage - startPage + 1 < maxPagesToShow) {
                startPage = Math.max(1, endPage - maxPagesToShow + 1);
            }

            const appendLink = (page, text, className = '') => {
                const link = document.createElement('a');
                link.href = '#'; // Prevent actual navigation
                link.dataset.page = page;
                link.textContent = text;
                link.classList.add('px-3', 'py-1', 'rounded-md');
                if (className) link.classList.add(className);
                if (page === currentPage) link.classList.add('bg-blue-600', 'text-white'); // Active page style
                // Disable links for pages out of bounds or current page
                if (page < 1 || page > totalPages || page === currentPage) link.classList.add('pointer-events-none', 'opacity-50');

                link.addEventListener('click', (e) => {
                    e.preventDefault();
                    if (!link.classList.contains('disabled') && !link.classList.contains('pointer-events-none')) {
                        loadFunction(parseInt(link.dataset.page));
                    }
                });
                container.appendChild(link);
            };

            appendLink(currentPage - 1, 'Précédent', 'prev-page-btn');

            if (startPage > 1) {
                appendLink(1, '1');
                if (startPage > 2) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.classList.add('px-3', 'py-1');
                    container.appendChild(ellipsis);
                }
            }

            for (let i = startPage; i <= endPage; i++) {
                appendLink(i, i.toString(), i === currentPage ? 'current-page' : '');
            }

            if (endPage < totalPages) {
                if (endPage < totalPages - 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.classList.add('px-3', 'py-1');
                    container.appendChild(ellipsis);
                }
                appendLink(totalPages, totalPages.toString());
            }

            appendLink(currentPage + 1, 'Suivant', 'next-page-btn');
        }

        // Fonction pour formater les nombres en monnaie (Ar)
        function formatCurrency(amount) {
            return parseFloat(amount).toLocaleString('fr-FR', { style: 'currency', currency: 'MGA' });
        }

        // --- Fonctions de chargement des données pour la section des sorties détaillées ---
        let currentPageSortiesDetails = 1;
        async function loadSortiesDetailsData(page = 1) {
            const filterVehiculeSigle = document.getElementById('filter_vehicule_sigle').value;
            const filterIdClient = document.getElementById('filter_id_client').value; // Récupération du filtre client
            const filterStartDate = document.getElementById('filter_start_date').value;
            const filterEndDate = document.getElementById('filter_end_date').value;


            try {
                let queryString = `action=get_filtered_sorties_data&page=${page}`;
                if (filterVehiculeSigle) queryString += `&filter_vehicule_sigle=${encodeURIComponent(filterVehiculeSigle)}`;
                if (filterIdClient) queryString += `&filter_id_client=${encodeURIComponent(filterIdClient)}`; // Ajout du filtre client
                // Ajouter les filtres de date de début et de fin
                if (filterStartDate) queryString += `&filter_start_date=${encodeURIComponent(filterStartDate)}`;
                if (filterEndDate) queryString += `&filter_end_date=${encodeURIComponent(filterEndDate)}`;

                const response = await fetch(`details_sorties_globales.php?${queryString}`);
                const data = await response.json();

                const sortiesDetailsTableBody = document.getElementById('sortiesDetailsTableBody');
                const sortiesDetailsPagination = document.getElementById('sortiesDetailsPagination');
                sortiesDetailsTableBody.innerHTML = '';

                if (data.success && data.data.length > 0) {
                    data.data.forEach(sortie => {
                        const row = `
                            <tr>
                                <td>${sortie.id_sortie}</td>
                                <td>${new Date(sortie.date_sortie).toLocaleDateString('fr-FR')}</td>
                                <td>${sortie.id_intervention} (${new Date(sortie.date_intervention).toLocaleDateString('fr-FR')})</td>
                                <td>${sortie.immatriculation} (${sortie.sigle || 'N/A'})</td>
                                <td>${sortie.nom_client || 'N/A'}</td>
                                <td title="${sortie.details_pieces_resume}">${sortie.details_pieces_resume ? sortie.details_pieces_resume.substring(0, 70) + (sortie.details_pieces_resume.length > 70 ? '...' : '') : 'N/A'}</td>
                                <td>${formatCurrency(parseFloat(sortie.total_ttc) || 0)}</td>
                            </tr>
                        `;
                        sortiesDetailsTableBody.insertAdjacentHTML('beforeend', row);
                    });
                    generatePagination(sortiesDetailsPagination, data.current_page, data.total_pages, loadSortiesDetailsData);
                } else {
                    sortiesDetailsTableBody.innerHTML = `<tr><td colspan="7" class="text-center">${data.message || 'Aucune sortie trouvée avec les filtres appliqués.'}</td></tr>`;
                    sortiesDetailsPagination.innerHTML = '';
                }
                currentPageSortiesDetails = page;
            } catch (error) {
                console.error('Erreur AJAX lors du chargement des sorties détaillées:', error);
                showMessage('Erreur technique lors du chargement des données de sorties.', 'error');
            }
        }

        let salesChartInstance = null; // Variable pour stocker l'instance du graphique

        // Fonction pour charger et rendre le graphique des ventes par sigle véhicule
        async function loadAndRenderSalesChart() {
            const filterVehiculeSigle = document.getElementById('filter_vehicule_sigle').value;
            const filterIdClient = document.getElementById('filter_id_client').value; // Récupération du filtre client
            const filterStartDate = document.getElementById('filter_start_date').value;
            const filterEndDate = document.getElementById('filter_end_date').value;

            const salesChartCanvas = document.getElementById('salesChart');
            const noDataMessageDiv = document.getElementById('noChartDataMessage');

            try {
                let queryString = `action=get_chart_data`;
                if (filterVehiculeSigle) queryString += `&filter_vehicule_sigle=${encodeURIComponent(filterVehiculeSigle)}`;
                if (filterIdClient) queryString += `&filter_id_client=${encodeURIComponent(filterIdClient)}`; // Ajout du filtre client
                if (filterStartDate) queryString += `&filter_start_date=${encodeURIComponent(filterStartDate)}`;
                if (filterEndDate) queryString += `&filter_end_date=${encodeURIComponent(filterEndDate)}`;

                const response = await fetch(`details_sorties_globales.php?${queryString}`);
                const data = await response.json();

                if (data.success && data.data.length > 0) {
                    noDataMessageDiv.classList.add('hidden');
                    salesChartCanvas.classList.remove('hidden'); 

                    const labels = data.data.map(item => item.vehicule_sigle || 'N/A');
                    const salesDataHT  = data.data.map(item => parseFloat(item.total_ht_par_sigle));
                    const salesDataTTC = data.data.map(item => parseFloat(item.total_ttc_par_sigle));


                    const ctx = salesChartCanvas.getContext('2d');

                    if (salesChartInstance) {
                        salesChartInstance.destroy();
                    }

                    salesChartInstance = new Chart(ctx, {
                            type: 'bar',
                            data: {
                                labels: labels,
                                datasets: [
                                    {
                                        label: 'Montant HT',
                                        data: salesDataHT,
                                        backgroundColor: 'rgba(12, 81, 229, 0.6)',
                                        borderColor: 'rgba(75, 158, 188, 1)',
                                        borderWidth: 1
                                    },
                                    {
                                        label: 'Montant TTC',
                                        data: salesDataTTC,
                                        backgroundColor: 'rgba(71, 255, 230, 0.6)',
                                        borderColor: 'rgba(71, 255, 237, 1)',
                                        borderWidth: 1
                                    }
                                ]
                            },

                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: {
                                    labels: { color: 'var(--text-color)' }
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function(context) {
                                            let label = context.dataset.label || '';
                                            if (label) { label += ': '; }
                                            if (context.parsed.y !== null) {
                                                label += formatCurrency(context.parsed.y);
                                            }
                                            return label;
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    grid: { color: 'rgba(0, 0, 0, 0.1)' },
                                    ticks: { color: 'var(--text-color)' }
                                },
                                y: {
                                    beginAtZero: true,
                                    grid: { color: 'rgba(0, 0, 0, 0.1)' },
                                    ticks: {
                                        color: 'var(--text-color)',
                                        callback: function(value) {
                                            return formatCurrency(value);
                                        }
                                    }
                                }
                            }
                        }
                    });
                } else {
                    if (salesChartInstance) {
                        salesChartInstance.destroy();
                        salesChartInstance = null;
                    }
                    salesChartCanvas.classList.add('hidden');
                    noDataMessageDiv.classList.remove('hidden');
                }
            } catch (error) {
                console.error('Erreur AJAX lors du chargement des données du graphique:', error);
                if (salesChartInstance) {
                    salesChartInstance.destroy();
                    salesChartInstance = null;
                }
                salesChartCanvas.classList.add('hidden');
                noDataMessageDiv.classList.remove('hidden');
                noDataMessageDiv.textContent = 'Erreur lors du chargement du graphique.';
                showMessage('Erreur technique lors du chargement des données du graphique.', 'error');
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            // ... [le début de votre DOMContentLoaded reste inchangé]

            // Filtres et boutons
            const filterVehiculeSigleSelect = document.getElementById('filter_vehicule_sigle');
            const filterIdClientSelect = document.getElementById('filter_id_client');
            const filterStartDateInput = document.getElementById('filter_start_date');
            const filterEndDateInput = document.getElementById('filter_end_date');
            const applyFiltersBtn = document.getElementById('apply_filters_sorties');
            const generateInvoicePdfBtn = document.getElementById('generate_invoice_pdf_btn');
            const generateExcelBtn = document.getElementById('generate_excel_btn'); // NOUVEAU : Récupération du bouton Excel

            // Événements pour les filtres et le bouton d'application
            applyFiltersBtn.addEventListener('click', () => {
                loadSortiesDetailsData(1);
                loadAndRenderSalesChart();
            });
            filterVehiculeSigleSelect.addEventListener('change', () => {
                loadSortiesDetailsData(1);
                loadAndRenderSalesChart();
            });
            filterIdClientSelect.addEventListener('change', () => {
                loadSortiesDetailsData(1);
                loadAndRenderSalesChart();
            });
            filterStartDateInput.addEventListener('change', () => {
                loadSortiesDetailsData(1);
                loadAndRenderSalesChart();
            });
            filterEndDateInput.addEventListener('change', () => {
                loadSortiesDetailsData(1);
                loadAndRenderSalesChart();
            });

            // Événement pour le bouton "Générer Facture PDF"
            generateInvoicePdfBtn.addEventListener('click', () => {
                const filterVehiculeSigle = document.getElementById('filter_vehicule_sigle').value;
                const filterIdClient = document.getElementById('filter_id_client').value;
                const filterStartDate = document.getElementById('filter_start_date').value;
                const filterEndDate = document.getElementById('filter_end_date').value;

                let queryString = ``;
                if (filterVehiculeSigle !== 'all') queryString += `filter_vehicule_sigle=${encodeURIComponent(filterVehiculeSigle)}&`;
                if (filterIdClient !== 'all') queryString += `filter_id_client=${encodeURIComponent(filterIdClient)}&`;
                if (filterStartDate) queryString += `filter_start_date=${encodeURIComponent(filterStartDate)}&`;
                if (filterEndDate) queryString += `filter_end_date=${encodeURIComponent(filterEndDate)}&`;

                if (queryString.endsWith('&')) {
                    queryString = queryString.slice(0, -1);
                }
                window.open(`generate_facture_globales_pdf.php?${queryString}`, '_blank');
            });

            // NOUVEAU : Événement pour le bouton "Générer Excel"
            generateExcelBtn.addEventListener('click', () => {
                const filterVehiculeSigle = document.getElementById('filter_vehicule_sigle').value;
                const filterIdClient = document.getElementById('filter_id_client').value;
                const filterStartDate = document.getElementById('filter_start_date').value;
                const filterEndDate = document.getElementById('filter_end_date').value;

                let queryString = ``;
                if (filterVehiculeSigle !== 'all') queryString += `filter_vehicule_sigle=${encodeURIComponent(filterVehiculeSigle)}&`;
                if (filterIdClient !== 'all') queryString += `filter_id_client=${encodeURIComponent(filterIdClient)}&`;
                if (filterStartDate) queryString += `filter_start_date=${encodeURIComponent(filterStartDate)}&`;
                if (filterEndDate) queryString += `filter_end_date=${encodeURIComponent(filterEndDate)}&`;

                if (queryString.endsWith('&')) {
                    queryString = queryString.slice(0, -1);
                }
                // Ouvre la page de génération Excel dans un nouvel onglet
                window.open(`generate_sorties_globales_excel.php?${queryString}`, '_blank');
            });

            // Chargement initial des données et du graphique
            loadSortiesDetailsData(1);
            loadAndRenderSalesChart();
            
            // ... [le reste de votre DOMContentLoaded (sparkles) reste inchangé]
        });
    </script>
</body>
</html>